/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext;

import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.AbstractWSDLElement;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.WSDL11DocumentImpl;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11AddressElement;

public class SOAP11AddressElementImpl extends AbstractWSDLElement implements SOAP11AddressElement {

    private static final long serialVersionUID = 1L;

    public SOAP11AddressElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public SOAP11AddressElementImpl() {
        super();
    }

    public void setLocation(String value) {
        setAttribute("location", value);
    }

    public String getLocation() {
        return getAttribute("location").equals("") ? null : getAttribute("location");
    }
}
