/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.xml.XMLConstants;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.xerces.dom.DocumentImpl;
import org.bluestemsoftware.open.eoa.commons.util.QNameUtils;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.ActorElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.ApplicationElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.EngineElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.RoleElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP11AddressElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP11BindingElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP11BodyElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP11FaultElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP11HeaderElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP11OperationElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP12AddressElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP12BindingElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP12BodyElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP12FaultElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP12HeaderElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext.SOAP12OperationElementImpl;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.util.Constants;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.util.DOMSerializer;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.util.DocumentContext;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.WSDLTypesElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.BindingElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.BindingOperationElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.BindingOperationFaultElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.BindingOperationInputElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.BindingOperationOutputElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.DefinitionsElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ImportElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.MessageElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.MessagePartElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.PortTypeElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.PortTypeOperationElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.PortTypeOperationFaultElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.PortTypeOperationInputElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.PortTypeOperationOutputElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ServiceElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ServicePortElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.TypesElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.ActorElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.ApplicationElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.EngineElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.RoleElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11AddressElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11BindingElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11BodyElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11FaultElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11HeaderElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11OperationElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP12AddressElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP12BindingElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP12BodyElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP12FaultElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP12HeaderElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP12OperationElement;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchema;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDL11DocumentImpl extends DocumentImpl implements WSDL11Document, WSDL11Document.Provider {

    private static final long serialVersionUID = 1L;
    private DocumentContext documentContext;
    private int prefixCounter = 1;

    public WSDL11DocumentImpl() {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.RootExtension#getExtensionType()
     */
    public final String getExtensionType() {
        return WSDL11Document.TYPE;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension#getExtensionFactory()
     */
    public final ExtensionFactory getExtensionFactory() {
        return SystemContext.getContext().getSystem().getIDLFactory(WSDL11Document.TYPE);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension#getExtensionProvider()
     */
    public org.bluestemsoftware.specification.eoa.ext.Extension.Provider getExtensionProvider() {
        return this;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.Extension)
     */
    public void spi_setConsumer(Extension consumer) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.WSDLDocument$Provider#addNamespace(java.lang.String)
     */
    public synchronized String addNamespace(String ns) {
        DefinitionsElement definitionsElement = getDefinitionsElement();
        if (definitionsElement == null) {
            return null;
        }
        String prefix = lookupPrefix(ns);
        if (prefix == null) {
            String tns = definitionsElement.getTargetNamespace();
            if (tns != null && tns.equals(ns)) {
                prefix = "tns";
            } else {
                String counterAsString = String.valueOf(prefixCounter++);
                if (counterAsString.length() == 1) {
                    counterAsString = "0" + counterAsString;
                }
                prefix = "ns" + counterAsString;
            }
            definitionsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, ns);
        }
        return prefix;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.WSDLDocument$Provider#getTargetNamespace()
     */
    public String getTargetNamespace() {
        return getDefinitionsElement().getTargetNamespace();
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.WSDLDocument$Provider#getTypesElement()
     */
    public WSDLTypesElement getTypesElement() {
        return getDefinitionsElement().getTypesElement();
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#getDefinitionsElement()
     */
    public DefinitionsElement getDefinitionsElement() {
        return (DefinitionsElement)getDocumentElement();
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createDefinitionsElement()
     */
    public DefinitionsElement createDefinitionsElement() {
        return new DefinitionsElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#setDefinitionsElement(org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.DefinitionsElement)
     */
    public void setDefinitionsElement(DefinitionsElement definitionsElement) {
        appendChild(definitionsElement);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createImportElement()
     */
    public ImportElement createImportElement() {
        return new ImportElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createTypesElement()
     */
    public TypesElement createTypesElement() {
        return new TypesElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createMessageElement()
     */
    public MessageElement createMessageElement() {
        return new MessageElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createMessagePartElement()
     */
    public MessagePartElement createMessagePartElement() {
        return new MessagePartElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createPortTypeElement()
     */
    public PortTypeElement createPortTypeElement() {
        return new PortTypeElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createPortTypeOperationElement()
     */
    public PortTypeOperationElement createPortTypeOperationElement() {
        return new PortTypeOperationElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createPortTypeOperationInputElement()
     */
    public PortTypeOperationInputElement createPortTypeOperationInputElement() {
        return new PortTypeOperationInputElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createPortTypeOperationOutputElement()
     */
    public PortTypeOperationOutputElement createPortTypeOperationOutputElement() {
        return new PortTypeOperationOutputElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createPortTypeOperationFaultElement()
     */
    public PortTypeOperationFaultElement createPortTypeOperationFaultElement() {
        return new PortTypeOperationFaultElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createBindingElement()
     */
    public BindingElement createBindingElement() {
        return new BindingElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createBindingOperationElement()
     */
    public BindingOperationElement createBindingOperationElement() {
        return new BindingOperationElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createBindingOperationInputElement()
     */
    public BindingOperationInputElement createBindingOperationInputElement() {
        return new BindingOperationInputElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createBindingOperationOutputElement()
     */
    public BindingOperationOutputElement createBindingOperationOutputElement() {
        return new BindingOperationOutputElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createBindingOperationFaultElement()
     */
    public BindingOperationFaultElement createBindingOperationFaultElement() {
        return new BindingOperationFaultElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createServiceElement()
     */
    public ServiceElement createServiceElement() {
        return new ServiceElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createServicePortElement()
     */
    public ServicePortElement createServicePortElement() {
        return new ServicePortElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createApplicationElement()
     */
    public ApplicationElement createApplicationElement() {
        return new ApplicationElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createEngineElement()
     */
    public EngineElement createEngineElement() {
        return new EngineElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createRoleElement()
     */
    public RoleElement createRoleElement() {
        return new RoleElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createActorElement()
     */
    public ActorElement createActorElement() {
        return new ActorElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP11AddressElement()
     */
    public SOAP11AddressElement createSOAP11AddressElement() {
        return new SOAP11AddressElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP11BindingElement()
     */
    public SOAP11BindingElement createSOAP11BindingElement() {
        return new SOAP11BindingElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP11BodyElement()
     */
    public SOAP11BodyElement createSOAP11BodyElement() {
        return new SOAP11BodyElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP11FaultElement()
     */
    public SOAP11FaultElement createSOAP11FaultElement() {
        return new SOAP11FaultElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP11HeaderElement()
     */
    public SOAP11HeaderElement createSOAP11HeaderElement() {
        return new SOAP11HeaderElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP11OperationElement()
     */
    public SOAP11OperationElement createSOAP11OperationElement() {
        return new SOAP11OperationElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP12AddressElement()
     */
    public SOAP12AddressElement createSOAP12AddressElement() {
        return new SOAP12AddressElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP12BindingElement()
     */
    public SOAP12BindingElement createSOAP12BindingElement() {
        return new SOAP12BindingElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP12BodyElement()
     */
    public SOAP12BodyElement createSOAP12BodyElement() {
        return new SOAP12BodyElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP12FaultElement()
     */
    public SOAP12FaultElement createSOAP12FaultElement() {
        return new SOAP12FaultElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP12HeaderElement()
     */
    public SOAP12HeaderElement createSOAP12HeaderElement() {
        return new SOAP12HeaderElementImpl(this);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document$Provider#createSOAP12OperationElement()
     */
    public SOAP12OperationElement createSOAP12OperationElement() {
        return new SOAP12OperationElementImpl(this);
    }

    /**
     * Overrides ancestor such that we can intercept invocations by DOMParser and return a wsdl
     * element if qname matches an expected name. Note that in some cases, qname of some
     * elements are the same and we must therefore examine context within which element is
     * being created, i.e. whose the parent, to return the correct element.
     */
    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName, String localpart) throws DOMException {
        QName elementName = new QName(namespaceURI, localpart);
        if (elementName.equals(DefinitionsElement.NAME)) {
            return new DefinitionsElementImpl(this);
        }
        if (elementName.equals(ImportElement.NAME)) {
            return new ImportElementImpl(this);
        }
        if (elementName.equals(TypesElement.NAME)) {
            return new TypesElementImpl(this);
        }
        if (elementName.equals(MessageElement.NAME)) {
            return new MessageElementImpl(this);
        }
        if (elementName.equals(MessagePartElement.NAME)) {
            return new MessagePartElementImpl(this);
        }
        if (elementName.equals(PortTypeElement.NAME)) {
            return new PortTypeElementImpl(this);
        }
        if (elementName.equals(PortTypeOperationElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(PortTypeElement.NAME)) {
                    return new PortTypeOperationElementImpl(this);
                }
            }
        }
        if (elementName.equals(PortTypeOperationInputElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(PortTypeOperationElement.NAME)) {
                    Element grandParent = (Element)parent.getParentNode();
                    QName grandParentName = new QName(grandParent.getNamespaceURI(), grandParent.getLocalName());
                    if (grandParentName.equals(PortTypeElement.NAME)) {
                        return new PortTypeOperationInputElementImpl(this);
                    }
                }
            }
        }
        if (elementName.equals(PortTypeOperationOutputElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(PortTypeOperationElement.NAME)) {
                    Element grandParent = (Element)parent.getParentNode();
                    QName grandParentName = new QName(grandParent.getNamespaceURI(), grandParent.getLocalName());
                    if (grandParentName.equals(PortTypeElement.NAME)) {
                        return new PortTypeOperationOutputElementImpl(this);
                    }
                }
            }
        }
        if (elementName.equals(PortTypeOperationFaultElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(PortTypeOperationElement.NAME)) {
                    Element grandParent = (Element)parent.getParentNode();
                    QName grandParentName = new QName(grandParent.getNamespaceURI(), grandParent.getLocalName());
                    if (grandParentName.equals(PortTypeElement.NAME)) {
                        return new PortTypeOperationFaultElementImpl(this);
                    }
                }
            }
        }
        if (elementName.equals(BindingElement.NAME)) {
            return new BindingElementImpl(this);
        }
        if (elementName.equals(BindingOperationElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(BindingElement.NAME)) {
                    return new BindingOperationElementImpl(this);
                }
            }
        }
        if (elementName.equals(BindingOperationInputElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(BindingOperationElement.NAME)) {
                    Element grandParent = (Element)parent.getParentNode();
                    QName grandParentName = new QName(grandParent.getNamespaceURI(), grandParent.getLocalName());
                    if (grandParentName.equals(BindingElement.NAME)) {
                        return new BindingOperationInputElementImpl(this);
                    }
                }
            }
        }
        if (elementName.equals(BindingOperationOutputElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(BindingOperationElement.NAME)) {
                    Element grandParent = (Element)parent.getParentNode();
                    QName grandParentName = new QName(grandParent.getNamespaceURI(), grandParent.getLocalName());
                    if (grandParentName.equals(BindingElement.NAME)) {
                        return new BindingOperationOutputElementImpl(this);
                    }
                }
            }
        }
        if (elementName.equals(BindingOperationFaultElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(BindingOperationElement.NAME)) {
                    Element grandParent = (Element)parent.getParentNode();
                    QName grandParentName = new QName(grandParent.getNamespaceURI(), grandParent.getLocalName());
                    if (grandParentName.equals(BindingElement.NAME)) {
                        return new BindingOperationFaultElementImpl(this);
                    }
                }
            }
        }
        if (elementName.equals(ServiceElement.NAME)) {
            return new ServiceElementImpl(this);
        }
        if (elementName.equals(ServicePortElement.NAME)) {
            return new ServicePortElementImpl(this);
        }
        if (elementName.equals(ApplicationElement.NAME)) {
            return new ApplicationElementImpl(this);
        }
        if (elementName.equals(RoleElement.NAME)) {
            return new RoleElementImpl(this);
        }
        if (elementName.equals(EngineElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(DefinitionsElement.NAME)) {
                    return new EngineElementImpl(this);
                }
            }
        }
        if (elementName.equals(ActorElement.NAME)) {
            Element parent = documentContext.getParent();
            if (parent != null) {
                QName parentName = new QName(parent.getNamespaceURI(), parent.getLocalName());
                if (parentName.equals(EngineElement.NAME)) {
                    return new ActorElementImpl(this);
                }
            }
        }
        if (elementName.equals(SOAP11AddressElement.NAME)) {
            return new SOAP11AddressElementImpl(this);
        }
        if (elementName.equals(SOAP11BindingElement.NAME)) {
            return new SOAP11BindingElementImpl(this);
        }
        if (elementName.equals(SOAP11BodyElement.NAME)) {
            return new SOAP11BodyElementImpl(this);
        }
        if (elementName.equals(SOAP11FaultElement.NAME)) {
            return new SOAP11FaultElementImpl(this);
        }
        if (elementName.equals(SOAP11HeaderElement.NAME)) {
            return new SOAP11HeaderElementImpl(this);
        }
        if (elementName.equals(SOAP11OperationElement.NAME)) {
            return new SOAP11OperationElementImpl(this);
        }
        if (elementName.equals(SOAP12AddressElement.NAME)) {
            return new SOAP12AddressElementImpl(this);
        }
        if (elementName.equals(SOAP12BindingElement.NAME)) {
            return new SOAP12BindingElementImpl(this);
        }
        if (elementName.equals(SOAP12BodyElement.NAME)) {
            return new SOAP12BodyElementImpl(this);
        }
        if (elementName.equals(SOAP12FaultElement.NAME)) {
            return new SOAP12FaultElementImpl(this);
        }
        if (elementName.equals(SOAP12HeaderElement.NAME)) {
            return new SOAP12HeaderElementImpl(this);
        }
        if (elementName.equals(SOAP12OperationElement.NAME)) {
            return new SOAP12OperationElementImpl(this);
        }
        return super.createElementNS(namespaceURI, qualifiedName, localpart);
    }

    /*
     * (non-Javadoc)
     * @see org.apache.xerces.dom.CoreDocumentImpl#createElementNS(java.lang.String,
     *      java.lang.String)
     */
    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localPart = QNameUtils.getLocalPart(qualifiedName);
        return createElementNS(namespaceURI, qualifiedName, localPart);
    }

    public void setDocumentContext(DocumentContext documentContext) {
        this.documentContext = documentContext;
    }

    public DocumentContext getDocumentContext() {
        return documentContext;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.IDLDocument#getGrammarDocuments()
     */
    public Set<Document> getGrammarDocuments() {

        Set<Document> schemaDocuments = new HashSet<Document>();

        WSDLTypesElement typesElement = getTypesElement();

        if (typesElement == null) {
            return schemaDocuments;
        }

        DocumentBuilder db;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        } catch (ParserConfigurationException pe) {
            throw new IllegalStateException("Error retrieving grammar documents. " + pe);
        }
        
        for (Element schemaElement : getChildElements(typesElement, new QName(XMLSchema.TYPE, "*"))) {

            Document document = db.newDocument();

            if (schemaElement.getLocalName().equals("import")) {

                document.appendChild(document.importNode(schemaElement, true));

            } else {

                String tns = schemaElement.getAttribute("targetNamespace");

                if (tns.equals("")) {

                    // wsdl 11 allows schema tns to be undefined as long as xs:import
                    // or xs:annotation are its only children. we're looking
                    // for import elements

                    for (Element i : getChildElements(schemaElement, new QName(XMLSchema.TYPE, "import"))) {

                        document.appendChild(document.importNode(i, true));

                    }

                } else {

                    document.appendChild(document.importNode(schemaElement, true));

                }

            }
            
            schemaDocuments.add(document);

        }

        return schemaDocuments;

    }

    private List<Element> getChildElements(Element parent, QName childName) {
        List<Element> answer = new ArrayList<Element>();
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            if (nodeList.item(i).getNodeType() != Node.ELEMENT_NODE) {
                continue;
            }
            Element element = (Element)nodeList.item(i);
            if (childName.getNamespaceURI().equals(XMLConstants.NULL_NS_URI)) {
                if (element.getNamespaceURI() != null) {
                    continue;
                }
            } else {
                if (element.getNamespaceURI() == null) {
                    continue;
                }
                if (!childName.getNamespaceURI().equals("*")
                        && !element.getNamespaceURI().equals(childName.getNamespaceURI())) {
                    continue;
                }
            }
            if (!childName.getLocalPart().equals("*") && !element.getLocalName().equals(childName.getLocalPart())) {
                continue;
            }
            answer.add(element);
        }
        return answer;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            DOMSerializer.serializeNode(this, writer, Constants.UTF_8, true);
        } catch (Exception ex) {
            return super.toString();
        }
        return writer.toString();
    }

}
