/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.AbstractWSDLElement;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.WSDL11DocumentImpl;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.ActorElement;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.EngineElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class EngineElementImpl extends AbstractWSDLElement implements EngineElement {

    private static final long serialVersionUID = 1L;

    private boolean isRead;
    private Map<QName, ActorElement> actorElements = new HashMap<QName, ActorElement>();

    public EngineElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public EngineElementImpl() {
        super();
    }

    public boolean isRead() {
        return isRead;
    }

    public void setIsRead(boolean isRead) {
        this.isRead = isRead;
    }
    
    public void setName(String name) {
        setAttribute("name", name);
    }

    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }

    public ActorElement addActorElement(ActorElement actorElement) {
        super.insertBefore(actorElement, null);
        if (actorElement.getService() == null) {
            throw new IllegalArgumentException("Required attribute 'service' not set on 'actor' element.");
        }
        actorElements.put(actorElement.getService(), actorElement);
        return actorElement;
    }

    public Map<QName, ActorElement> getActorElements() {
        return actorElements;
    }

    public void setApplication(ComponentName value) {
        if (value == null) {
            return;
        }
        String prefix = ((WSDL11DocumentImpl)getOwnerDocument()).addNamespace(value.getNamespaceURI());
        setAttribute("application", prefix + ":" + value.getLocalPart());
    }

    public ComponentName getApplication() {
        String temp = getAttribute("application");
        if (temp.equals("")) {
            return null;
        }
        return ComponentName.valueOf(this, temp);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(ActorElement.NAME)) {
                return addActorElement((ActorElement)newChild);
            }
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(ActorElement.NAME)) {
                actorElements.remove(((ActorElement)oldChild).getService());
            }
        }
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = oldChild.getNamespaceURI();
            String localPart = oldChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(ActorElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(ActorElement.NAME)) {
                throw new DOMException(DOMException.HIERARCHY_REQUEST_ERR, DOMMessageFormatter.formatMessage(
                        DOMMessageFormatter.DOM_DOMAIN, "HIERARCHY_REQUEST_ERR", null));
            }
        }
        return super.insertBefore(newChild, refChild);
    }

    
}
