/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.ext;

import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.AbstractWSDLElement;
import org.bluestemsoftware.open.eoa.ext.idl.wsdl.wsdl11.xerces.WSDL11DocumentImpl;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.ext.SOAP11FaultElement;

public class SOAP11FaultElementImpl extends AbstractWSDLElement implements SOAP11FaultElement {

    private static final long serialVersionUID = 1L;

    public SOAP11FaultElementImpl(WSDL11DocumentImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public SOAP11FaultElementImpl() {
        super();
    }

    public void setName(String value) {
        setAttribute("name", value);
    }

    public String getName() {
        return getAttribute("name").equals("") ? null : getAttribute("name");
    }
    
    public void setUse(String value) {
        setAttribute("use", value);
    }

    public String getUse() {
        return getAttribute("use").equals("") ? null : getAttribute("use");
    }

    public String getNamespace() {
        return getAttribute("namespace").equals("") ? null : getAttribute("namespace");
    }

    public void setNamespace(String value) {
        setAttribute("namespace", value);
    }
    
}
