/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.schema.xs.xs10.xerces;

import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchemaInclude;

public final class XMLSchemaIncludeImpl extends XMLSchemaReferenceImpl implements XMLSchemaInclude {

    private static final long serialVersionUID = 1L;
    
    public XMLSchemaIncludeImpl(XMLSchemaImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }
    
    // *********************** Identity Methods ************************************
    
    @Override
    public final int hashCode() {
        return hashCode(getSchemaLocation());
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }

        if (!(obj instanceof XMLSchemaIncludeImpl)) {
            return false;
        }

        if ((getSchemaLocation() == ((XMLSchemaIncludeImpl)obj).getSchemaLocation() || (getSchemaLocation() != null && getSchemaLocation()
                .equals(((XMLSchemaIncludeImpl)obj).getSchemaLocation())))) {
            return true;
        }

        return false;
    }

    private int hashCode(Object object) {
        return (object == null ? 0 : object.hashCode());
    }


}
