/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.schema.xs.xs10.xerces;

import org.apache.xerces.dom.DocumentImpl;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XSTypeDefinition;
import org.w3c.dom.DOMException;

public abstract class XSTypeDefinitionImpl extends AbstractSchemaElement implements XSTypeDefinition {

    protected XSTypeDefinitionImpl(DocumentImpl ownerDocument, String namespaceURI, String qualifiedName)
            throws DOMException {
        super(ownerDocument, namespaceURI, qualifiedName);
    }

    public final String getName() {
        return getAttribute("name");
    }

}
