/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.schema.xs.xs10.xerces;

import org.apache.xerces.dom.DocumentImpl;
import org.bluestemsoftware.specification.eoa.component.FragmentIdentifier;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.XMLSchemaException;
import org.w3c.dom.DOMException;

public abstract class XMLSchemaReferenceImpl extends AbstractSchemaElement {

    private static final long serialVersionUID = 1L;

    protected FragmentIdentifier fragmentIdentifier;

    protected XMLSchemaReferenceImpl(DocumentImpl ownerDocument, String namespaceURI, String qualifiedName)
            throws DOMException {
        super(ownerDocument, namespaceURI, qualifiedName);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.Extension.Consumer)
     */
    public void spi_setConsumer(Extension consumer) {
    }

    public FragmentIdentifier spi_getSchemaFragmentIdentifier() {
        return getSchemaFragmentIdentifier();
    }

    public String getSchemaLocation() {
        return getAttribute("schemaLocation");
    }

    public void setSchemaLocation(String value) {
        super.setAttribute("schemaLocation", value);
    }

    /**
     * Gets fragmentIdentifier of referenced schema.
     * @return
     * @throws XMLSchemaException
     */
    public FragmentIdentifier getSchemaFragmentIdentifier() {
        return fragmentIdentifier;
    }
    
    public void setSchemaFragmentIdentifier(FragmentIdentifier fragmentIdentifier) {
        this.fragmentIdentifier = fragmentIdentifier;
    }
    
}
