/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.schema.xs.xs10.xerces;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchemaElement;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchemaImport;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchemaInclude;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchemaRedefine;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchemaReference;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XSComplexTypeDefinition;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XSElementDeclaration;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XSSimpleTypeDefinition;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XSTypeDefinition;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSchemaElementImpl extends AbstractSchemaElement implements XMLSchemaElement {

    private static final long serialVersionUID = 1L;

    private Set<XSElementDeclaration> elementDeclElements = new HashSet<XSElementDeclaration>();
    private Set<XSTypeDefinition> typeDefElements = new HashSet<XSTypeDefinition>();
    private Set<Element> otherElements = new HashSet<Element>();
    Map<Integer, XMLSchemaReference> schemaReferenceElements = new HashMap<Integer, XMLSchemaReference>();
    
    public XMLSchemaElementImpl(XMLSchemaImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }

    public void setTargetNamespace(String targetNamespace) {
        setAttribute("targetNamespace", targetNamespace);
    }

    public String getTargetNamespace() {
        return getAttribute("targetNamespace");
    }

    public String getID() {
        return getAttribute("id");
    }
    
    public Set<XSElementDeclaration> getElementDeclarations() {
        return elementDeclElements;
    }

    public Collection<XMLSchemaReference> getSchemaReferences() {
        return schemaReferenceElements.values();
    }

    public Set<XSTypeDefinition> getTypeDefinitions() {
        return typeDefElements;
    }


    public XMLSchemaImportImpl addImportElement(XMLSchemaImportImpl importElement) {
        if (importElement.getNamespace().equals("")) {
            throw new IllegalArgumentException("Required attribute 'namespace' not set.");
        }
        if (elementDeclElements.size() > 0) {
            super.insertBefore(importElement, elementDeclElements.iterator().next());
        } else if (typeDefElements.size() > 0) {
            super.insertBefore(importElement, typeDefElements.iterator().next());
        } else if (otherElements.size() > 0) {
            super.insertBefore(importElement, otherElements.iterator().next());
        } else {
            super.insertBefore(importElement, null);
        }
        schemaReferenceElements.put(new Integer(importElement.hashCode()), importElement);
        return importElement;
    }

    public XMLSchemaIncludeImpl addIncludeElement(XMLSchemaIncludeImpl includeElement) {
        if (includeElement.getSchemaLocation().equals("")) {
            throw new IllegalArgumentException("Required attribute 'schemaLocation' not set.");
        }
        if (elementDeclElements.size() > 0) {
            super.insertBefore(includeElement, elementDeclElements.iterator().next());
        } else if (typeDefElements.size() > 0) {
            super.insertBefore(includeElement, typeDefElements.iterator().next());
        } else if (otherElements.size() > 0) {
            super.insertBefore(includeElement, otherElements.iterator().next());
        } else {
            super.insertBefore(includeElement, null);
        }
        schemaReferenceElements.put(new Integer(includeElement.hashCode()), includeElement);
        return includeElement;
    }

    public XMLSchemaRedefineImpl addRedefineElement(XMLSchemaRedefineImpl redefineElement) {
        if (redefineElement.getSchemaLocation().equals("")) {
            throw new IllegalArgumentException("Required attribute 'schemaLocation' not set.");
        }
        if (elementDeclElements.size() > 0) {
            super.insertBefore(redefineElement, elementDeclElements.iterator().next());
        } else if (typeDefElements.size() > 0) {
            super.insertBefore(redefineElement, typeDefElements.iterator().next());
        } else if (otherElements.size() > 0) {
            super.insertBefore(redefineElement, otherElements.iterator().next());
        } else {
            super.insertBefore(redefineElement, null);
        }
        schemaReferenceElements.put(new Integer(redefineElement.hashCode()), redefineElement);
        return redefineElement;
    }

    public Collection<XMLSchemaReference> getSchemaReferenceElements() {
        return schemaReferenceElements.values();
    }

    public XSElementDeclarationImpl addElementDeclElement(XSElementDeclarationImpl elementDeclElement) {
        String name = elementDeclElement.getAttribute("name");
        if (name.equals("")) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        if (typeDefElements.size() > 0) {
            super.insertBefore(elementDeclElement, typeDefElements.iterator().next());
        } else if (otherElements.size() > 0) {
            super.insertBefore(elementDeclElement, otherElements.iterator().next());
        } else {
            super.insertBefore(elementDeclElement, null);
        }
        elementDeclElements.add(elementDeclElement);
        return elementDeclElement;
    }

    public Set<XSElementDeclaration> getElementDeclElements() {
        return elementDeclElements;
    }

    public XSTypeDefinitionImpl addTypeDefElement(XSTypeDefinitionImpl typeDefElement) {
        String name = typeDefElement.getAttribute("name");
        if (name.equals("")) {
            throw new IllegalArgumentException("Required attribute 'name' not set.");
        }
        if (otherElements.size() > 0) {
            super.insertBefore(typeDefElement, otherElements.iterator().next());
        } else {
            super.insertBefore(typeDefElement, null);
        }
        typeDefElements.add(typeDefElement);
        return typeDefElement;
    }

    public Set<XSTypeDefinition> getTypeDefElements() {
        return typeDefElements;
    }

    public Element addOtherElement(Element otherElement) {
        super.insertBefore(otherElement, null);
        otherElements.add(otherElement);
        return otherElement;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == Node.ELEMENT_NODE) {
            String namespaceURI = newChild.getNamespaceURI();
            String localPart = newChild.getLocalName();
            QName elementName = new QName(namespaceURI, localPart);
            if (elementName.equals(XMLSchemaImport.NAME)) {
                return addImportElement((XMLSchemaImportImpl)newChild);
            }
            if (elementName.equals(XMLSchemaInclude.NAME)) {
                return addIncludeElement((XMLSchemaIncludeImpl)newChild);
            }
            if (elementName.equals(XMLSchemaRedefine.NAME)) {
                return addRedefineElement((XMLSchemaRedefineImpl)newChild);
            }
            if (elementName.equals(XSElementDeclaration.NAME)) {
                return addElementDeclElement((XSElementDeclarationImpl)newChild);
            }
            if (elementName.equals(XSComplexTypeDefinition.NAME)) {
                return addTypeDefElement((XSComplexTypeDefinitionImpl)newChild);
            }
            if (elementName.equals(XSSimpleTypeDefinition.NAME)) {
                return addTypeDefElement((XSSimpleTypeDefinitionImpl)newChild);
            }
            return addOtherElement((Element)newChild);
        }
        return super.insertBefore(newChild, null);
    }
    
}

