/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.schema.xs.xs10.xerces;

import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XSElementDeclaration;


public final class XSElementDeclarationImpl extends AbstractSchemaElement implements XSElementDeclaration {

    private static final long serialVersionUID = 1L;
    
    public XSElementDeclarationImpl(XMLSchemaImpl owner) {
        super(owner, NAME.getNamespaceURI(), NAME.getPrefix() + ":" + NAME.getLocalPart());
    }
    
    public String getName() {
        return getAttribute("name");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.Extension.Consumer)
     */
    public void spi_setConsumer(Extension consumer) {
    }
        
    // *********************** Identity Methods ************************************

    @Override
    public final int hashCode() {
        return hashCode(getName());
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }

        if (!(obj instanceof XSElementDeclarationImpl)) {
            return false;
        }

        if ((getName() == ((XSElementDeclarationImpl)obj).getName() || (getName() != null && getName()
                .equals(((XSElementDeclarationImpl)obj).getName())))) {
            return true;
        }

        return false;
    }
    
    private int hashCode(Object object) {
        return (object == null ? 0 : object.hashCode());
    }
    
}
