/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.schema.xs.xs10.xerces.util;

import javax.xml.namespace.QName;

import org.bluestemsoftware.specification.eoa.ext.schema.SchemaFactory;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchema;


public final class Constants {
    
    public static final String EMPTY_STRING = "";
    public static final String FORWARD_SLASH = "/";
    public static final String LINE_BREAK = System.getProperty("line.separator");
    public static final String UTF_8 = System.getProperty("UTF-8");
    
    public static final String XS_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String EOA_WSDL_EXT_NAMESPACE = "http://bluestemsoftware.org/specification/eoa/1.0/component/";
    public static final String XS_NS_PREFIX = "xs";
    
    public static final String SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    public static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String IGNORABLE_WHITESPACE_FEATURE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    public static final String SCHEMA_LANGUAGE_PROPERTY = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String SCHEMA_LOCATION_PROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String GRAMMAR_POOL_PROPERTY = "http://apache.org/xml/properties/internal/grammar-pool";
    public static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String SCHEMA_FULL_CHECKING_FEATURE = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String DOCUMENT_CLASS_NAME_PROPERTY = "http://apache.org/xml/properties/dom/document-class-name";
    public static final String ENTITY_RESOLVER_PROPERTY = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String SCHEMA_DOCUMENT_CLASS_NAME = "org.bluestemsoftware.open.eoa.ext.schema.xs.xs10.xerces.XMLSchemaImpl";

    public static final QName QUERY_ELEMENT = new QName(SchemaFactory.EOA_SCHEMA_EXT_NS, "query");
    public static final QName SCHEMA_ELEMENT_NAME = new QName(XMLSchema.TYPE, "schema", Constants.XS_NS_PREFIX);
    public static final QName IMPORT_ELEMENT_NAME = new QName(XMLSchema.TYPE, "import", Constants.XS_NS_PREFIX);
    public static final QName INCLUDE_ELEMENT_NAME = new QName(XMLSchema.TYPE, "include", Constants.XS_NS_PREFIX);
    public static final QName REDEFINE_ELEMENT_NAME = new QName(XMLSchema.TYPE, "redefine", Constants.XS_NS_PREFIX);

    public static final String XML_SCHEMA_SCHEMA_LOCATION = "classpath:///schema/http.www.w3.org.2001.xmlschema.xsd";
    
}    
    
    
