/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.expression.xpath.xpath10.jaxen;

import java.util.Map;

import org.bluestemsoftware.specification.eoa.ext.expression.xpath.XPathException;
import org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpression;
import org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpressionFactory;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;

public final class XPathExpressionFactoryImpl implements XPathExpressionFactory.Provider {

    public static final String NAME = "xpath-10-jaxen";

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpressionFactory$Provider#spi_createExpression(java.lang.String)
     */
    public XPathExpression.Provider spi_createExpression(String query) throws XPathException {
        try {
            return new XPathExpressionImpl(new DOMXPath(query));
        } catch (JaxenException je) {
            throw new XPathException("Error creating expression. " + je.getMessage());
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.expression.ExpressionFactory$Provider#spi_createExpression(java.util.Map,
     *      java.lang.String)
     */
    public XPathExpression.Provider spi_createExpression(Map<String, String> namespaces, String query) throws XPathException {

        try {
            DOMXPath underlying = new DOMXPath(query);
            for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                underlying.addNamespace(entry.getKey(), entry.getValue());
            }
            return new XPathExpressionImpl(underlying);
        } catch (JaxenException je) {
            throw new XPathException("Error creating expression. " + je.getMessage());
        }

    }

}
