/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.expression.xpath.xpath10.jaxen;

import java.util.List;

import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.expression.EvaluationException;
import org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpression;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Node;

public class XPathExpressionImpl implements XPathExpression.Provider {

    private static final long serialVersionUID = 1L;
    private DOMXPath underlying;

    public XPathExpressionImpl(DOMXPath underlying) {
        this.underlying = underlying;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.Extension.Consumer)
     */
    public void spi_setConsumer(Extension consumer) {
    }

    public String spi_evaluateString(Node node) throws EvaluationException {
        try {
            return underlying.stringValueOf(node);
        } catch (JaxenException je) {
            throw new EvaluationException(je.getMessage());
        }
    }

    public Number spi_evaluateNumber(Node node) throws EvaluationException {
        try {
            return underlying.numberValueOf(node);
        } catch (JaxenException je) {
            throw new EvaluationException(je.getMessage());
        }
    }

    public Boolean spi_evaluateBoolean(Node node) throws EvaluationException {
        try {
            return underlying.booleanValueOf(node);
        } catch (JaxenException je) {
            throw new EvaluationException(je.getMessage());
        }
    }

    public Node spi_evaluateNode(Node node) throws EvaluationException {
        try {
            // not sure why jaxen api forces us to cast result to node.
            // docs indicate a single node is returned ...
            return (Node)underlying.selectSingleNode(node);
        } catch (JaxenException je) {
            throw new EvaluationException(je.getMessage());
        }
    }

    @SuppressWarnings("unchecked")
    public List<Node> spi_evaluateNodes(Node node) throws EvaluationException {
        try {
            Object object = underlying.evaluate(node);
            if (object instanceof List) {
                return (List<Node>)object;
            } else {
                throw new EvaluationException("Unable to convert result of evaluating expression to List<Node>."
                        + " Evaluation of expression resulted in "
                        + object.getClass().getName()
                        + ".");
            }
        } catch (JaxenException je) {
            throw new EvaluationException(je.getMessage());
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpression$Provider#spi_addNamespace(java.lang.String,
     *      java.lang.String)
     */
    public void spi_addNamespace(String prefix, String namespace) {
        try {
            underlying.addNamespace(prefix, namespace);
        } catch (JaxenException je) {
            throw new IllegalArgumentException(je.getMessage());
        }
    }

}
