/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.commons.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitInputStream
extends FilterInputStream {
    private int readLimit;
    private int bytesRead;

    public LimitInputStream(InputStream in, int readLimit) {
        super(in);
        this.readLimit = readLimit;
    }

    public synchronized int read() throws IOException {
        if (this.bytesRead > this.readLimit) {
            throw new IOException("Number of bytes read exceeds set limit of " + this.readLimit + ".");
        }
        ++this.bytesRead;
        return super.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRead > this.readLimit) {
            throw new IOException("Number of bytes read exceeds set limit of " + this.readLimit + ".");
        }
        int localBytesRead = super.read(b, off, len);
        if (localBytesRead > 0) {
            this.bytesRead += localBytesRead;
        }
        return localBytesRead;
    }
}

