/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.commons.util;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMUtils {
    public static Element getFirstChildElement(Element parent) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return (Element)nodeList.item(i);
        }
        return null;
    }

    public static Element getChildElement(Element parent, QName childName) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            if (!childName.getNamespaceURI().equals("") ? element.getNamespaceURI() == null || !childName.getNamespaceURI().equals("*") && !element.getNamespaceURI().equals(childName.getNamespaceURI()) : element.getNamespaceURI() != null) continue;
            if (!childName.getLocalPart().equals("*") && !element.getLocalName().equals(childName.getLocalPart())) continue;
            return element;
        }
        return null;
    }

    public static List<Element> getChildElements(Element parent, QName childName) {
        ArrayList<Element> answer = new ArrayList<Element>();
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            if (!childName.getNamespaceURI().equals("") ? element.getNamespaceURI() == null || !childName.getNamespaceURI().equals("*") && !element.getNamespaceURI().equals(childName.getNamespaceURI()) : element.getNamespaceURI() != null) continue;
            if (!childName.getLocalPart().equals("*") && !element.getLocalName().equals(childName.getLocalPart())) continue;
            answer.add(element);
        }
        return answer;
    }

    public static String getText(Element element) {
        if (element == null || !element.hasChildNodes()) {
            return null;
        }
        try {
            Text textNode = (Text)element.getFirstChild();
            return textNode.getData();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    static class UnresolvedPrefixException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnresolvedPrefixException(String message) {
            super(message);
        }
    }
}

