/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.commons.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitOutputStream
extends FilterOutputStream {
    private int writeLimit;
    private int bytesWritten;

    public LimitOutputStream(OutputStream out, int writeLimit) {
        super(out);
        this.writeLimit = writeLimit;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bytesWritten > this.writeLimit) {
            throw new IOException("Number of bytes written exceeds set limit of " + this.writeLimit + ".");
        }
        this.bytesWritten += len - off;
        super.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        if (this.bytesWritten > this.writeLimit) {
            throw new IOException("Number of bytes written exceeds set limit of " + this.writeLimit + ".");
        }
        ++this.bytesWritten;
        super.write(b);
    }
}

