/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.commons.util.ddl;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDLParser
implements ErrorHandler,
EntityResolver {
    private List<String> errorMessages = new ArrayList<String>();
    static final String SCHEMA_LANGUAGE_ATTRIBUTE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String XML_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    static final String EXTERNAL_SCHEMA_PROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    static final String XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    static final String DDL_NS_URI = "http://bluestemsoftware.org/open/eoa/commons/util/ddl/1.0/";
    private ClassLoader classLoader = null;

    public void error(SAXParseException spe) throws SAXException {
        this.errorMessages.add(spe.getMessage());
    }

    public void warning(SAXParseException spe) throws SAXException {
        this.errorMessages.add(spe.getMessage());
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        this.errorMessages.add(spe.getMessage());
    }

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        String loc = null;
        if (systemID.endsWith("ddl.xsd")) {
            loc = "org/bluestemsoftware/open/eoa/commons/util/schema/ddl-1.0.xsd";
        } else if (systemID.endsWith("xml-schema.xsd")) {
            loc = "org/bluestemsoftware/open/eoa/container/standalone/xml-schema.xsd";
        } else if (systemID.endsWith("xml-schema.dtd")) {
            loc = "org/bluestemsoftware/open/eoa/container/standalone/xml-schema.dtd";
        } else if (systemID.endsWith("datatypes.dtd")) {
            loc = "org/bluestemsoftware/open/eoa/container/standalone/datatypes.dtd";
        }
        if (loc != null) {
            InputSource inputSource = new InputSource(this.classLoader.getResourceAsStream(loc));
            inputSource.setPublicId(publicID);
            inputSource.setSystemId(systemID);
            inputSource.setEncoding("UTF-8");
            return inputSource;
        }
        return null;
    }

    static class DDLException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DDLException() {
        }

        public DDLException(String message, Throwable cause) {
            super(message, cause);
        }

        public DDLException(String message) {
            super(message);
        }

        public DDLException(Throwable cause) {
            super(cause);
        }
    }
}

