/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.commons.util.ddl;

import java.util.ArrayList;
import java.util.List;

import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDLParser implements ErrorHandler, EntityResolver {

    
    //private DocumentBuilderFactory factory;
    private List<String> errorMessages = new ArrayList<String>();

    static final String SCHEMA_LANGUAGE_ATTRIBUTE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String XML_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    static final String EXTERNAL_SCHEMA_PROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    
    static final String XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    static final String DDL_NS_URI = "http://bluestemsoftware.org/open/eoa/commons/util/ddl/1.0/";
    
    private ClassLoader classLoader = null;
    
//    public DDLParser(ClassLoader classLoader) throws Exception {
//        
//        this.classLoader = classLoader;
//
//        // configure bootstrap parser using xerces bundled with
//        // jdk and set ourselves as error handler
//
//        factory = DocumentBuilderFactory.newInstance();
//        factory.setNamespaceAware(true);
//        factory.setValidating(true);
//        factory.setAttribute(SCHEMA_LANGUAGE_ATTRIBUTE, XML_SCHEMA_LANGUAGE);
//        
//        // set external schema property used by parser to locate
//        // schema via our entity resolver
//        
//        String externalSchemaProperty = "";
//        externalSchemaProperty = externalSchemaProperty + XML_SCHEMA_NS_URI + " xml-schema.xsd ";
//        externalSchemaProperty = externalSchemaProperty + DDL_NS_URI + " ddl.xsd";
//        factory.setAttribute(EXTERNAL_SCHEMA_PROPERTY, externalSchemaProperty.toString());
//        
//    }
//
//    public void createSchema(InputSource inputSource, DataSourceConnector connector) throws DDLException {
//        
//        errorMessages.clear();
//
//        DocumentBuilder builder;
//        try {
//            builder = factory.newDocumentBuilder();
//        } catch (ParserConfigurationException pe) {
//            throw new DDLException(pe);
//        }
//        
//        builder.setErrorHandler(this);
//        builder.setEntityResolver(this);
//
//        Document document = null;
//        try {
//            document = builder.parse(inputSource);
//        } catch (Exception ex) {
//            throw new DDLException(ex);
//        }
//
//        if (errorMessages.size() > 0) {
//            Iterator<String> messageIterator = errorMessages.iterator();
//            StringBuilder errorMessage = new StringBuilder();
//            while (messageIterator.hasNext()) {
//                errorMessage.append(messageIterator.next() + "  ");
//            }
//            throw new DDLException(errorMessage.toString());
//        }
//        
//        createSchemaImpl(document, connector);
//
//    }

    /** ******************** ErrorHandler Interface ******************************* */

    public void error(SAXParseException spe) throws SAXException {
        errorMessages.add(spe.getMessage());
    }

    public void warning(SAXParseException spe) throws SAXException {
        errorMessages.add(spe.getMessage());
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        errorMessages.add(spe.getMessage());
    }
    
    /** ******************** EntityResolver Interface ******************************* */
    
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        String loc = null;
        if (systemID.endsWith("ddl.xsd")) {
            loc = "org/bluestemsoftware/open/eoa/commons/util/schema/ddl-1.0.xsd";
        } else if (systemID.endsWith("xml-schema.xsd")) {
            loc = "org/bluestemsoftware/open/eoa/container/standalone/xml-schema.xsd";
        } else if (systemID.endsWith("xml-schema.dtd")) {
            loc = "org/bluestemsoftware/open/eoa/container/standalone/xml-schema.dtd";
        } else if (systemID.endsWith("datatypes.dtd")) {
            loc = "org/bluestemsoftware/open/eoa/container/standalone/datatypes.dtd";
        }
        if (loc != null) {
            InputSource inputSource = new InputSource(classLoader.getResourceAsStream(loc));
            inputSource.setPublicId(publicID);
            inputSource.setSystemId(systemID);
            inputSource.setEncoding("UTF-8");
            return inputSource;
        } else {
            return null;
        }
    }
    
    /** ***************************** Restricted Impl ********************************* */
    
//    private void createSchemaImpl(Document document, DataSourceConnector connector) {
        
//        Connection conn = null;
//        Statement stmt = null;
//
//        try {
//            
//            conn = connector.getConnection();
//            stmt = (Statement)conn.createStatement();
//
//            Element rootElement = document.getDocumentElement();
            
//            List<?> tables = document.getRootElement().elements();
//            if (tables != null && tables.size() > 0) {
//                Iterator<?> itr = tables.iterator();
//                Element table = null;
//                String tableName = null;
//                while (itr.hasNext()) {
//                    table = (Element)itr.next();
//                    tableName = table.attributeValue("name");
//                    if (table.attributeValue("autogen").equals("true")) {
//                        Element sqlElement = table.element("sql");
//                        Element existsElement = sqlElement.element("exists");
//                        String existsSQL = existsElement.getText();
//                        try {
//                            
//                            // TODO: here's a better way to test for existence of schema
//                            //
//                            //boolean tableExists = false;
//                            //ResultSet rs=null;
//                            //try {
//                            //    rs= c.getConnection().getMetaData().getTables(null,null, "MY_TABLE_NAME", new String[] {"TABLE"});
//                            //    tableExists = rs.next();                
//                            //} catch (Throwable ignore) {
//                            //} finally {
//                            //    close(rs);
//                            //}
//
//                            stmt.executeQuery(existsSQL);
//                            log.debug("table " + tableName + " exists");
//                            log.debug("no autogen required");
//
//                            // drop and re-create indexes to prevent fragmentation
//                            // and improve performance
//
//                            log.info("rebuilding indexes");
//
//                            Element indexesElement = sqlElement.element("indexes");
//                            if (indexesElement != null) {
//                                Iterator<?> indexItr = indexesElement.elementIterator();
//                                while (indexItr.hasNext()) {
//                                    Element indexElement = (Element)indexItr.next();
//                                    Element dropIndexElement = indexElement.element("drop");
//                                    String dropSQL = dropIndexElement.getText();
//                                    stmt.executeUpdate(dropSQL);
//                                    Element createIndexElement = indexElement.element("create");
//                                    String createSQL = createIndexElement.getText();
//                                    stmt.executeUpdate(createSQL);
//                                    log.debug("index created");
//                                }
//                            }
//
//                        } catch (SQLException se) {
//                            log.debug("'exists' sql threw exception. " + se);
//                            log.debug("assuming table not found.");
//                            log.info("creating table " + tableName);
//                            Element createElement = sqlElement.element("create");
//                            String createSQL = createElement.getText();
//                            stmt.executeUpdate(createSQL);
//                            log.debug("created table " + tableName);
//                            Element indexesElement = sqlElement.element("indexes");
//                            if (indexesElement != null) {
//                                Iterator<?> indexItr = indexesElement.elementIterator();
//                                while (indexItr.hasNext()) {
//                                    Element indexElement = (Element)indexItr.next();
//                                    Element createIndexElement = indexElement.element("create");
//                                    log.info("executing index script");
//                                    String indexSQL = createIndexElement.getText();
//                                    stmt.executeUpdate(indexSQL);
//                                    log.debug("index created");
//                                }
//                            }
//                            Element dataElement = sqlElement.element("data");
//                            if (dataElement != null) {
//                                Iterator<?> insertItr = dataElement.elementIterator();
//                                while (insertItr.hasNext()) {
//                                    Element insertElement = (Element)insertItr.next();
//                                    log.debug("executing insert stmt");
//                                    String insertSQL = insertElement.getText();
//                                    stmt.executeUpdate(insertSQL);
//                                    log.debug("data created");
//                                }
//                            }
//                        }
//                    }
//                }
//
//            } else {
//                throw new ServerException("DDL script at uri " + ddlScriptURI + " defines no tables.");
//            }
//        } catch (SQLException se) {
//            throw new ServerException("Error on init:" + se);
//        } finally {
//
//            try {
//                if (conn != null)
//                    conn.close();
//                if (stmt != null)
//                    stmt.close();
//            } catch (SQLException se) {
//                log.error(se.toString());
//            }
//
//        }

//    }
    
    
    /** ******************************* Inner Class *********************************** */
    
    static class DDLException extends Exception {

        private static final long serialVersionUID = 1L;

        public DDLException() {
            super();
        }

        public DDLException(String message, Throwable cause) {
            super(message, cause);
        }

        public DDLException(String message) {
            super(message);
        }

        public DDLException(Throwable cause) {
            super(cause);
        }
        
    }

}
