/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.commons.util;

import java.util.Enumeration;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMHandler
extends DefaultHandler
implements LexicalHandler {
    private DocumentBuilder documentBuilder;
    private Document document;
    private Stack<Element> elementStack;
    private NamespaceSupport namespaceStack;
    private boolean newContextRequired;
    private boolean insideCDATASection;
    private StringBuilder cdataText;
    private Element currentElement;
    private StringBuilder textBuffer;
    private boolean ignoreElementWhitespace;
    private boolean coalesceTextNodes;

    public DOMHandler(boolean ignoreElementWhitespace, boolean coalesceTextNodes) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.documentBuilder = dbf.newDocumentBuilder();
        this.elementStack = new Stack();
        this.namespaceStack = new NamespaceSupport();
        this.textBuffer = new StringBuilder();
        this.ignoreElementWhitespace = ignoreElementWhitespace;
        this.coalesceTextNodes = coalesceTextNodes;
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean isCoalesceTextNodes() {
        return this.coalesceTextNodes;
    }

    public boolean isIgnoreElementWhitespace() {
        return this.ignoreElementWhitespace;
    }

    public void startDocument() {
        this.document = this.documentBuilder.newDocument();
        this.newContextRequired = true;
    }

    public void endDocument() {
        this.elementStack.clear();
        this.namespaceStack.reset();
        this.textBuffer = new StringBuilder();
        this.cdataText = null;
        this.currentElement = null;
        this.newContextRequired = false;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.newContextRequired) {
            this.namespaceStack.pushContext();
            this.newContextRequired = false;
        }
        this.namespaceStack.declarePrefix(prefix, uri);
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.newContextRequired) {
            this.namespaceStack.pushContext();
        }
        this.completeCurrentTextNode();
        Element element = this.document.createElementNS(namespaceURI, qualifiedName);
        this.addAttributes(element, attributes);
        this.addDeclaredNamespaces(element);
        if (this.document.getDocumentElement() == null) {
            this.document.appendChild(element);
        } else {
            this.currentElement.appendChild(element);
        }
        this.elementStack.push(element);
        this.currentElement = element;
        this.newContextRequired = true;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.completeCurrentTextNode();
        this.elementStack.pop();
        this.currentElement = this.elementStack.size() == 0 ? null : this.elementStack.peek();
        this.namespaceStack.popContext();
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        if (end == 0) {
            return;
        }
        if (this.currentElement == null) {
            return;
        }
        if (this.insideCDATASection) {
            this.cdataText.append(new String(ch, start, end));
        } else if (this.coalesceTextNodes) {
            this.textBuffer.append(ch, start, end);
        } else {
            Text text = this.document.createTextNode(this.textBuffer.toString());
            this.currentElement.appendChild(text);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        throw new UnsupportedOperationException("startDTD");
    }

    public void endDTD() throws SAXException {
        throw new UnsupportedOperationException("endDTD");
    }

    public void startEntity(String name) throws SAXException {
        throw new UnsupportedOperationException("startEntity");
    }

    public void endEntity(String name) throws SAXException {
        throw new UnsupportedOperationException("endEntity");
    }

    public void startCDATA() throws SAXException {
        this.insideCDATASection = true;
        this.cdataText = new StringBuilder();
    }

    public void endCDATA() throws SAXException {
        this.insideCDATASection = false;
        CDATASection cdata = this.document.createCDATASection(this.cdataText.toString());
        this.currentElement.appendChild(cdata);
    }

    public void comment(char[] ch, int start, int end) throws SAXException {
    }

    private void completeCurrentTextNode() {
        if (this.textBuffer.length() == 0) {
            return;
        }
        if (this.ignoreElementWhitespace) {
            boolean whitespace = true;
            int size = this.textBuffer.length();
            for (int i = 0; i < size; ++i) {
                if (Character.isWhitespace(this.textBuffer.charAt(i))) continue;
                whitespace = false;
                break;
            }
            if (!whitespace) {
                Text text = this.document.createTextNode(this.textBuffer.toString());
                this.currentElement.appendChild(text);
            }
        } else {
            Text text = this.document.createTextNode(this.textBuffer.toString());
            this.currentElement.appendChild(text);
        }
        this.textBuffer.setLength(0);
    }

    private void addDeclaredNamespaces(Element element) {
        Enumeration<String> enumeration = this.namespaceStack.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String prefix = enumeration.nextElement();
            String uri = this.namespaceStack.getURI(prefix);
            if (prefix.equals("")) {
                element.setAttribute("xmlns", uri);
                continue;
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
    }

    private void addAttributes(Element element, Attributes attributes) {
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            String attributeQName = attributes.getQName(i);
            if (attributeQName.startsWith("xmlns")) continue;
            String namespaceURI = attributes.getURI(i);
            String qualifiedName = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (namespaceURI.equals("")) {
                element.setAttribute(qualifiedName, value);
                continue;
            }
            element.setAttributeNS(namespaceURI, qualifiedName, value);
        }
    }
}

