/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.commons.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DOMValidator {
    private Schema schema;

    public DOMValidator(Schema schema) {
        this.schema = schema;
    }

    public String validate(DOMSource source) throws SAXException, IOException {
        Validator validator = this.schema.newValidator();
        validator.setErrorHandler(new ErrorHandlerImpl());
        validator.validate(source);
        return ((ErrorHandlerImpl)validator.getErrorHandler()).getErrors();
    }

    static class ErrorHandlerImpl
    implements ErrorHandler {
        private ArrayList<String> errorMessages = new ArrayList();

        ErrorHandlerImpl() {
        }

        public void error(SAXParseException spe) throws SAXException {
            this.errorMessages.add(spe.getMessage());
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.errorMessages.add(spe.getMessage());
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            this.errorMessages.add(spe.getMessage());
        }

        public String getErrors() {
            if (this.errorMessages.size() > 0) {
                Iterator<String> messageIterator = this.errorMessages.iterator();
                StringBuilder errorMessage = new StringBuilder();
                while (messageIterator.hasNext()) {
                    errorMessage.append(messageIterator.next() + "  ");
                }
                return errorMessage.toString();
            }
            return null;
        }
    }
}

