/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.commons.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackArchive(File archive, File outputDir, boolean isDestinationTemporary) throws Exception {
        outputDir.mkdir();
        if (isDestinationTemporary) {
            outputDir.deleteOnExit();
        }
        ZipFile zipFile = new ZipFile(archive);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(outputDir, File.separator + entry.getName());
                if (entry.isDirectory()) {
                    FileUtils.mkdirs(file);
                    continue;
                }
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = zipFile.getInputStream(entry);
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buffer = new byte[4096];
                    int length = 0;
                    while (length >= 0) {
                        out.write(buffer, 0, length);
                        length = in.read(buffer);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                if (!isDestinationTemporary) continue;
                file.deleteOnExit();
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyDir(File source, File target, boolean isDestinationTemporary) throws Exception {
        target.mkdir();
        if (isDestinationTemporary) {
            target.deleteOnExit();
        }
        File[] entries = source.listFiles();
        for (int i = 0; i < entries.length; ++i) {
            File entry = entries[i];
            File file = new File(target, File.separator + entry.getName());
            if (entry.isDirectory()) {
                FileUtils.copyDir(entry, file, isDestinationTemporary);
                continue;
            }
            FileInputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(entry);
                out = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buffer = new byte[4096];
                int length = 0;
                while (length >= 0) {
                    out.write(buffer, 0, length);
                    length = ((InputStream)in).read(buffer);
                }
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            if (!isDestinationTemporary) continue;
            file.deleteOnExit();
        }
        return target;
    }

    public static boolean deleteFile(File file) {
        boolean result = true;
        if (file.exists()) {
            File[] contents;
            if (file.isDirectory() && (contents = file.listFiles()) != null) {
                for (int i = 0; i < contents.length; ++i) {
                    File content = contents[i];
                    if (content.isDirectory()) {
                        result &= FileUtils.deleteFile(content);
                        continue;
                    }
                    result &= content.delete();
                }
            }
            return result & file.delete();
        }
        return result;
    }

    private static void mkdirs(File child) {
        if (!child.exists()) {
            child.mkdir();
            child.deleteOnExit();
        }
        for (File parent = child.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
            parent.mkdir();
            parent.deleteOnExit();
        }
    }
}

