/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.commons.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class QNameUtils {

    private static Pattern prefixedNameRegExp = Pattern.compile("((\\S+):){0,}(\\w+)");
    
    public static String getPrefix(String qualifiedName) {
        if (qualifiedName != null) {
            Matcher matcher = prefixedNameRegExp.matcher(qualifiedName);
            if (matcher.find()) {
                return matcher.group(2);
            } else {
                return null;
            }
        } else {
            return null;    
        }
    }
    
    public static String getLocalPart(String qualifiedName) {
        if (qualifiedName != null) {
            Matcher matcher = prefixedNameRegExp.matcher(qualifiedName);
            if (matcher.find()) {
                return matcher.group(3);
            } else {
                return null;
            }
        } else {
            return null;    
        }
    }
    
}
