/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.commons.util;

import java.io.File;
import java.net.URI;

public final class URIUtils {
    public static final File toFile(URI uri, String extension) {
        if (uri == null || !uri.isAbsolute()) {
            throw new IllegalArgumentException("invalid uri");
        }
        String location = uri.getScheme() == null ? "" : uri.getScheme();
        location = uri.getHost() == null ? location : location + '.' + uri.getHost();
        location = uri.getPort() < 0 ? location : location + '.' + uri.getPort();
        location = uri.getPath() == null ? location : location + uri.getPath();
        location = uri.getFragment() == null ? location : location + '.' + uri.getFragment();
        location = location.replaceAll("/", ".");
        location = location.replaceAll("\\\\", ".");
        location = location.replaceAll(":", ".");
        location = location.replaceAll("\\*", ".");
        location = location.replaceAll("\\?", ".");
        location = location.replaceAll("\"", ".");
        location = location.replaceAll("<", ".");
        location = location.replaceAll(">", ".");
        location = location.replaceAll("\\|", ".");
        location = location.replaceAll("\\(", ".");
        location = location.replaceAll("\\)", ".");
        if (extension != null) {
            location = location.endsWith(".") ? location : location + '.';
            location = location.endsWith(extension) ? location : location + extension;
        } else {
            location = location.endsWith(".") ? location.substring(0, location.length() - 1) : location;
        }
        return new File(location);
    }
}

