/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.simpleftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.maven.plugin.logging.Log;

public class SimpleFTP {
    private Log log;
    private Socket socket = null;
    private BufferedReader reader = null;
    private BufferedWriter writer = null;
    private static boolean DEBUG = false;

    public SimpleFTP(Log log) {
        this.log = log;
    }

    public synchronized void connect(String host) throws IOException {
        this.connect(host, 21);
    }

    public synchronized void connect(String host, int port) throws IOException {
        this.connect(host, port, "anonymous", "anonymous");
    }

    public synchronized void connect(String host, int port, String user, String pass) throws IOException {
        if (this.socket != null) {
            throw new IOException("SimpleFTP is already connected. Disconnect first.");
        }
        this.socket = new Socket(host, port);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        String response = this.readLine();
        if (!response.startsWith("220 ")) {
            throw new IOException("SimpleFTP received an unknown response when connecting to the FTP server: " + response);
        }
        this.sendLine("USER " + user);
        response = this.readLine();
        if (!response.startsWith("331 ")) {
            throw new IOException("SimpleFTP received an unknown response after sending the user: " + response);
        }
        this.sendLine("PASS " + pass);
        response = this.readLine();
        if (!response.startsWith("230 ")) {
            throw new IOException("SimpleFTP was unable to log in with the supplied password: " + response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() throws IOException {
        try {
            this.sendLine("QUIT");
        }
        finally {
            this.socket = null;
        }
    }

    public synchronized String pwd() throws IOException {
        int firstQuote;
        int secondQuote;
        this.sendLine("PWD");
        String dir = null;
        String response = this.readLine();
        if (response.startsWith("257 ") && (secondQuote = response.indexOf(34, (firstQuote = response.indexOf(34)) + 1)) > 0) {
            dir = response.substring(firstQuote + 1, secondQuote);
        }
        return dir;
    }

    public synchronized boolean exists(String file) throws IOException {
        this.sendLine("SIZE " + file);
        String response = this.readLine();
        return !response.startsWith("550 ");
    }

    public synchronized boolean chmod(String perms, String file) throws IOException {
        this.sendLine("SITE CHMOD " + perms + " " + file);
        String response = this.readLine();
        this.log.debug((CharSequence)("chmod response: " + response));
        return response.startsWith("200 ");
    }

    public synchronized boolean cwd(String dir) throws IOException {
        this.sendLine("CWD " + dir);
        String response = this.readLine();
        this.log.debug((CharSequence)("cwd response: " + response));
        return response.startsWith("250 ");
    }

    public synchronized boolean stor(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("SimpleFTP cannot upload a directory.");
        }
        String filename = file.getName();
        return this.stor(new FileInputStream(file), filename);
    }

    public synchronized boolean stor(InputStream inputStream, String filename) throws IOException {
        BufferedInputStream input = new BufferedInputStream(inputStream);
        this.sendLine("PASV");
        String response = this.readLine();
        if (!response.startsWith("227 ")) {
            throw new IOException("SimpleFTP could not request passive mode: " + response);
        }
        String ip = null;
        int port = -1;
        int opening = response.indexOf(40);
        int closing = response.indexOf(41, opening + 1);
        if (closing > 0) {
            String dataLink = response.substring(opening + 1, closing);
            StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
            try {
                ip = tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken();
                port = Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
            }
            catch (Exception e) {
                throw new IOException("SimpleFTP received bad data link information: " + response);
            }
        }
        this.sendLine("STOR " + filename);
        Socket dataSocket = new Socket(ip, port);
        response = this.readLine();
        if (!response.startsWith("150 ")) {
            throw new IOException("SimpleFTP was not allowed to send the file: " + response);
        }
        BufferedOutputStream output = new BufferedOutputStream(dataSocket.getOutputStream());
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        output.flush();
        output.close();
        input.close();
        response = this.readLine();
        this.log.debug((CharSequence)("stor response: " + response));
        return response.startsWith("226 ");
    }

    public synchronized boolean bin() throws IOException {
        this.sendLine("TYPE I");
        String response = this.readLine();
        return response.startsWith("200 ");
    }

    public synchronized boolean ascii() throws IOException {
        this.sendLine("TYPE A");
        String response = this.readLine();
        return response.startsWith("200 ");
    }

    private void sendLine(String line) throws IOException {
        if (this.socket == null) {
            throw new IOException("SimpleFTP is not connected.");
        }
        try {
            this.writer.write(line + "\r\n");
            this.writer.flush();
            if (DEBUG) {
                System.out.println("> " + line);
            }
        }
        catch (IOException e) {
            this.socket = null;
            throw e;
        }
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        if (DEBUG) {
            System.out.println("< " + line);
        }
        return line;
    }
}

