/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.maven.plugin.ftp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.bluestemsoftware.open.maven.plugin.ftp.Server;
import org.jibble.simpleftp.InvalidPasswordException;
import org.jibble.simpleftp.SimpleFTP;

public class FTPMojo
extends AbstractMojo {
    private String targetDirectory;
    private List<Server> servers = new ArrayList<Server>();

    public void execute() throws MojoExecutionException {
        for (Server server : this.servers) {
            SimpleFTP ftp = new SimpleFTP(this.getLog());
            String url = server.getUrl();
            String user = server.getUser();
            String prompt = "Password for " + user + "@" + url + ": ";
            char[] passwd = System.console().readPassword(prompt, null);
            try {
                this.getLog().info((CharSequence)"connecting ...");
                try {
                    ftp.connect(url, 21, user, new String(passwd));
                }
                catch (InvalidPasswordException ie) {
                    try {
                        prompt = "Invalid password. Try again. ";
                        passwd = System.console().readPassword(prompt, null);
                        ftp.connect(url, 21, user, new String(passwd));
                    }
                    catch (InvalidPasswordException iee) {
                        prompt = "Invalid password. Last Chance! ";
                        passwd = System.console().readPassword(prompt, null);
                        ftp.connect(url, 21, user, new String(passwd));
                    }
                }
                ftp.bin();
                ftp.cwd(server.getTarget());
                this.getLog().info((CharSequence)("working directory is " + ftp.pwd()));
                for (String file : server.getFiles()) {
                    if (ftp.exists(file)) {
                        this.getLog().warn((CharSequence)("not overwriting file " + file));
                        continue;
                    }
                    this.getLog().info((CharSequence)("uploading file " + file));
                    if (!ftp.stor(new File(this.targetDirectory, file))) {
                        throw new MojoExecutionException("Failed transferring file " + file + ".");
                    }
                    if (ftp.chmod("444", file)) continue;
                    throw new MojoExecutionException("Failed flagging file " + file + " as readonly.");
                }
                this.getLog().info((CharSequence)"upload successful");
                ftp.disconnect();
            }
            catch (IOException ie) {
                throw new MojoExecutionException("Error uploading files. " + ie);
            }
        }
    }
}

