/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.maven.plugin.install;

import java.io.File;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

/**
 * Attaches a build artifact to project so that it will be available to other plugins which
 * process project after this mojo. It should be defined via the execution tag and associated
 * with the verify phase.
 * 
 * @goal attach
 */
public class AttachMojo extends AbstractMojo {

    /**
     * The maven project.
     * 
     * @parameter expression="${project}"
     * @required
     * @readonly
     * @description "the maven project to use"
     */
    private MavenProject project;
    
    /**
     * 
     * Project helper injected by maven.
     * 
     * @component
     */
    private MavenProjectHelper projectHelper;

    /**
     * The file to be attached
     * 
     * @parameter
     * @required
     */
    private File file;
    
    /**
     * The classifier used to distinguish this artifact from the main project artifact.
     * 
     * @parameter 
     * @required
     */
    private String classifier;
    
    /**
     * The extension used to for target file, i.e. file to which artifact will be
     * installed within the repository.
     * 
     * @parameter 
     * @required
     */
    private String extension;

      /*
     * (non-Javadoc)
     * @see org.apache.maven.plugin.AbstractMojo#execute()
     */
    public void execute() throws MojoExecutionException {

        // add optional exe file, i.e. which is used to launch the install jar
        // on windows platforms
        
        if (file.exists()) {
            projectHelper.attachArtifact(project, extension, classifier, file);
        } else {
            getLog().warn("file to attach " + file.getAbsolutePath() + " not found.");
        }


    }
}
