/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.maven.plugin.install;

import java.io.File;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

/**
 * Overwrites main project artifact with indicated file which will be installed within install
 * phase.
 * 
 * @goal file
 * @phase verify
 */
public class FileMojo extends AbstractMojo {

    /**
     * @parameter expression="${project.artifact}"
     * @required
     * @readonly
     */
    private Artifact artifact;

    /**
     * The maven project.
     * 
     * @parameter expression="${project}"
     * @required
     * @readonly
     * @description "the maven project to use"
     */
    private MavenProject project;

    /**
     * The file to be deployed
     * 
     * @parameter expression="${file}"
     * @required
     */
    private File file;
    
    /**
     * 
     * Project helper injected by maven.
     * 
     * @component
     */
    private MavenProjectHelper ph;

    /*
     * (non-Javadoc)
     * @see org.apache.maven.plugin.AbstractMojo#execute()
     */
    public void execute() throws MojoExecutionException {
        artifact.setFile(file);
        String temp = file.getName().substring(0, file.getName().lastIndexOf("."));
        temp = temp + "-sources.jar";
        File sources = new File(file.getParent(), temp);
        if (sources.exists()) {
            ph.attachArtifact(project, "jar", "sources", sources);
        }
    }

}
