/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import com.izforge.izpack.util.OsConstraint;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pack
implements Serializable {
    private static final long serialVersionUID = -4567516722161738334L;
    public boolean loose;
    public boolean uninstall;
    public String name;
    public String id;
    public Set<String> installGroups = new HashSet<String>();
    public String excludeGroup = "";
    public String group;
    public String description;
    public List<OsConstraint> osConstraints = null;
    private String condition;
    public List<String> dependencies = null;
    public List<String> revDependencies = null;
    public boolean required;
    public long nbytes;
    public boolean preselected;
    public String parent;
    public int color;
    public String packImgId;
    public URL digestLocation;
    public static final int WHITE = 0;
    public static final int GREY = 1;
    public static final int BLACK = 2;
    private static final double KILOBYTES = 1024.0;
    private static final double MEGABYTES = 1048576.0;
    private static final double GIGABYTES = 1.073741824E9;
    private static final DecimalFormat formatter = new DecimalFormat("#,###.##");

    public Pack(String name, String id, String description, List<OsConstraint> osConstraints, List<String> dependencies, boolean required, boolean preselected, boolean loose, String excludegroup, boolean uninstall) {
        this.name = name;
        this.id = id;
        this.description = description;
        this.osConstraints = osConstraints;
        this.dependencies = dependencies;
        this.required = required;
        this.preselected = preselected;
        this.loose = loose;
        this.excludeGroup = excludegroup;
        this.uninstall = uninstall;
        this.packImgId = null;
        this.condition = null;
        this.nbytes = 0L;
        this.color = 0;
    }

    public URL getDigestLocation() {
        return this.digestLocation;
    }

    public void setDigestLocation(URL digestLocation) {
        this.digestLocation = digestLocation;
    }

    public String toString() {
        return this.name + " (" + this.description + ")";
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void addRevDep(String name0) {
        if (this.revDependencies == null) {
            this.revDependencies = new ArrayList<String>();
        }
        this.revDependencies.add(name0);
    }

    public String depString() {
        String name0;
        String text = "";
        if (this.dependencies == null) {
            return text;
        }
        for (int i = 0; i < this.dependencies.size() - 1; ++i) {
            name0 = this.dependencies.get(i);
            text = text + name0 + ",";
        }
        name0 = this.dependencies.get(this.dependencies.size() - 1);
        text = text + name0;
        return text;
    }

    public static String toByteUnitsString(long bytes) {
        if ((double)bytes < 1024.0) {
            return String.valueOf(bytes) + " bytes";
        }
        if ((double)bytes < 1048576.0) {
            double value = (double)bytes / 1024.0;
            return formatter.format(value) + " KB";
        }
        if ((double)bytes < 1.073741824E9) {
            double value = (double)bytes / 1048576.0;
            return formatter.format(value) + " MB";
        }
        double value = (double)bytes / 1.073741824E9;
        return formatter.format(value) + " GB";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }
}

