/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.compiler.ByteCountingOutputStream;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.Packager;
import com.izforge.izpack.compiler.PackagerHelper;
import com.izforge.izpack.util.JarOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Pack200;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import net.n3.nanoxml.XMLElement;
import org.apache.tools.zip.ZipEntry;

public class WebPackager
extends Packager {
    private Map<String, String> pack200Props = new HashMap<String, String>();

    public void addConfigurationInformation(XMLElement data) {
        XMLElement pack200Element = data.getFirstChildNamed("pack200");
        if (pack200Element != null) {
            for (XMLElement propertyElement : pack200Element.getChildren()) {
                String propertyName = propertyElement.getAttribute("name");
                if (propertyName == null) {
                    throw new RuntimeException("pack200 options property element missing required 'name' attribute.");
                }
                String propertyValue = propertyElement.getAttribute("value");
                if (propertyName == null) {
                    throw new RuntimeException("pack200 options property element missing required 'value' attribute.");
                }
                this.pack200Props.put(propertyName, propertyValue);
            }
        }
    }

    public void createInstaller(File primaryFile) throws Exception {
        String baseName = primaryFile.getName();
        if (baseName.endsWith(".jar")) {
            baseName = baseName.substring(0, baseName.length() - 4);
            this.baseFile = new File(primaryFile.getParentFile(), baseName);
        } else {
            this.baseFile = primaryFile;
        }
        this.info.setInstallerBase(this.baseFile.getName());
        if (this.info.getWebDirURL() == null) {
            throw new CompilerException("WebPackager requires specification of a 'webdir' URL.");
        }
        this.packJarsSeparate = true;
        File file = new File(this.baseFile.getParentFile(), this.baseFile.getName() + ".jar");
        this.sendMsg("Building installer jar: " + file.getAbsolutePath());
        this.primaryJarStream = new JarOutputStream(file);
        this.primaryJarStream.setLevel(9);
        this.primaryJarStream.setPreventClose(true);
        this.sendStart();
        this.writeInstaller();
        this.primaryJarStream.closeAlways();
        this.sendStop();
    }

    protected void writePacks() throws Exception {
        int packNumber = 1;
        Iterator packIter = this.packsList.iterator();
        XMLElement root = new XMLElement("packs");
        while (packIter.hasNext()) {
            PackInfo packInfo = (PackInfo)packIter.next();
            Pack pack = packInfo.getPack();
            if (pack.id == null || pack.id.length() == 0) {
                pack.id = pack.name;
            }
            boolean isLocalInstallation = this.info.getWebDirURL().equals("./");
            String jarName = this.baseFile.getName() + ".pack-" + pack.id + ".jar";
            File jarFile = new File(this.baseFile.getParentFile(), jarName);
            ByteCountingOutputStream bos = new ByteCountingOutputStream(new FileOutputStream(jarFile));
            ZipOutputStream packStream = new ZipOutputStream(bos);
            packStream.setLevel(0);
            this.sendMsg("Writing pack " + packNumber + ": " + pack.name, 2);
            java.util.zip.ZipEntry entry = new java.util.zip.ZipEntry("metadata");
            packStream.putNextEntry(entry);
            packStream.flush();
            ObjectOutputStream objOut = new ObjectOutputStream(packStream);
            objOut.writeInt(packInfo.getPackFiles().size());
            for (PackFile pf : packInfo.getPackFiles()) {
                objOut.writeObject(pf);
                objOut.flush();
            }
            objOut.writeInt(packInfo.getParsables().size());
            Iterator iter = packInfo.getParsables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getExecutables().size());
            iter = packInfo.getExecutables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getUpdateChecks().size());
            iter = packInfo.getUpdateChecks().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.flush();
            packStream.closeEntry();
            this.sendMsg("Writing pack files ... ", 2);
            for (PackFile pf : packInfo.getPackFiles()) {
                File file = packInfo.getFile(pf);
                if (pf.isDirectory()) continue;
                entry = new java.util.zip.ZipEntry(pf.getTargetPath());
                packStream.putNextEntry(entry);
                PackagerHelper.copyStream(new FileInputStream(file), packStream);
                packStream.closeEntry();
            }
            packStream.flush();
            objOut.close();
            if (!isLocalInstallation) {
                this.sendMsg("Compressing pack using pack200 + gzip ... ", 2);
                JarFile source = new JarFile(jarFile);
                File p200File = new File(this.baseFile.getParentFile(), jarName + ".pack.gz");
                Pack200.Packer packer = Pack200.newPacker();
                packer.properties().putAll(this.pack200Props);
                FileOutputStream fos = new FileOutputStream(p200File);
                bos = new ByteCountingOutputStream(fos);
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                BufferedOutputStream out = new BufferedOutputStream(gos);
                packer.pack(source, (OutputStream)out);
                ((OutputStream)out).close();
                source.close();
            }
            pack.nbytes = bos.getByteCount();
            XMLElement child = new XMLElement("pack");
            child.setAttribute("nbytes", Long.toString(pack.nbytes));
            child.setAttribute("name", pack.name);
            if (pack.id != null) {
                child.setAttribute("id", pack.id);
            }
            root.addChild(child);
            ++packNumber;
        }
        this.primaryJarStream.putNextEntry(new ZipEntry("packs.info"));
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)((Object)this.primaryJarStream));
        out.writeInt(this.packsList.size());
        for (PackInfo pack : this.packsList) {
            out.writeObject(pack.getPack());
        }
        out.flush();
        this.primaryJarStream.closeEntry();
    }
}

