/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPanelWorker
implements Runnable {
    private static final String SPEC_RESOURCE_NAME = "ProcessPanel.Spec.xml";
    private VariableSubstitutor vs;
    protected AbstractUIProcessHandler handler;
    private ArrayList<ProcessingJob> jobs = new ArrayList();
    private boolean result = true;
    private static PrintWriter logfile = null;
    private String logfiledir = null;
    protected AutomatedInstallData idata;

    public ProcessPanelWorker(AutomatedInstallData idata, AbstractUIProcessHandler handler) throws IOException {
        this.handler = handler;
        this.idata = idata;
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    private boolean readSpec() throws IOException {
        XMLElement spec;
        InputStream input;
        try {
            input = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setValidator(new NonValidator());
        try {
            parser.setReader(new StdXMLReader(input));
            spec = (XMLElement)parser.parse();
        }
        catch (Exception e) {
            System.err.println("Error parsing XML specification for processing.");
            System.err.println(e.toString());
            return false;
        }
        if (!spec.hasChildren()) {
            return false;
        }
        XMLElement lfd = spec.getFirstChildNamed("logfiledir");
        if (lfd != null) {
            this.logfiledir = lfd.getContent();
        }
        for (XMLElement job_el : spec.getChildrenNamed("job")) {
            String arg_val;
            ArrayList<String> args;
            String ef_name;
            List<OsConstraint> constraints;
            String conditionid = job_el.getAttribute("conditionid");
            if (conditionid != null) {
                Debug.trace("Condition for job.");
                Condition cond = RulesEngine.getCondition(conditionid);
                if (cond != null && !cond.isTrue()) {
                    Debug.trace("condition is not fulfilled.");
                    continue;
                }
            }
            Debug.trace("Condition is fulfilled or not existent.");
            Vector<XMLElement> forPacks = job_el.getChildrenNamed("executeForPack");
            if (!this.jobRequiredFor(forPacks) || !OsConstraint.oneMatchesCurrentSystem(constraints = OsConstraint.getOsList(job_el))) continue;
            ArrayList<Processable> ef_list = new ArrayList<Processable>();
            String job_name = job_el.getAttribute("name", "");
            for (XMLElement ef : job_el.getChildrenNamed("executefile")) {
                ef_name = ef.getAttribute("name");
                if (ef_name == null || ef_name.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executefile>");
                    return false;
                }
                args = new ArrayList<String>();
                for (XMLElement arg_el : ef.getChildrenNamed("arg")) {
                    arg_val = arg_el.getContent();
                    args.add(arg_val);
                }
                ef_list.add(new ExecutableFile(ef_name, args));
            }
            for (XMLElement ef : job_el.getChildrenNamed("executeclass")) {
                ef_name = ef.getAttribute("name");
                if (ef_name == null || ef_name.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executeclass>");
                    return false;
                }
                args = new ArrayList();
                for (XMLElement arg_el : ef.getChildrenNamed("arg")) {
                    arg_val = arg_el.getContent();
                    args.add(arg_val);
                }
                ef_list.add(new ExecutableClass(ef_name, args));
            }
            this.jobs.add(new ProcessingJob(job_name, ef_list));
        }
        return true;
    }

    @Override
    public void run() {
        try {
            if (!this.readSpec()) {
                System.err.println("Error parsing XML specification for processing.");
                return;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            return;
        }
        if (this.logfiledir != null) {
            this.logfiledir = IoHelper.translatePath(this.logfiledir, new VariableSubstitutor(this.idata.getVariables()));
            String appVersion = this.idata.getVariable("APP_VER");
            appVersion = appVersion != null ? "V" + appVersion : "undef";
            String identifier = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            identifier = appVersion.replace(' ', '_') + "_" + identifier;
            try {
                File lf = File.createTempFile("Install_" + identifier + "_", ".log", new File(this.logfiledir));
                logfile = new PrintWriter(new FileOutputStream(lf), true);
            }
            catch (IOException e) {
                Debug.error(e);
            }
        }
        this.handler.startProcessing(this.jobs.size());
        for (ProcessingJob pj : this.jobs) {
            this.handler.startProcess(pj.name);
            this.result = pj.run(this.handler, this.vs);
            this.handler.finishProcess();
            if (this.result) continue;
            break;
        }
        this.handler.finishProcessing();
        if (logfile != null) {
            logfile.close();
        }
    }

    public void startThread() {
        Thread processingThread = new Thread((Runnable)this, "processing thread");
        processingThread.start();
    }

    public boolean getResult() {
        return this.result;
    }

    private boolean jobRequiredFor(Vector<XMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = packs.elementAt(k).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutableClass
    implements Processable {
        private final String myClassName;
        private final List<String> myArguments;
        protected AbstractUIProcessHandler myHandler;

        public ExecutableClass(String className, List<String> args) {
            this.myClassName = className;
            this.myArguments = args;
        }

        @Override
        public boolean run(AbstractUIProcessHandler aHandler, VariableSubstitutor varSubstitutor) {
            boolean result = false;
            this.myHandler = aHandler;
            String[] params = new String[this.myArguments.size()];
            int i = 0;
            for (String myArgument : this.myArguments) {
                params[i++] = varSubstitutor.substitute(myArgument, "plain");
            }
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> procClass = loader.loadClass(this.myClassName);
                Object o = procClass.newInstance();
                Method m = procClass.getMethod("run", AbstractUIProcessHandler.class, String[].class);
                m.invoke(o, this.myHandler, params);
                result = true;
            }
            catch (SecurityException e) {
                this.myHandler.emitError("Post Processing Error", "Security exception thrown when processing class: " + this.myClassName);
            }
            catch (ClassNotFoundException e) {
                this.myHandler.emitError("Post Processing Error", "Cannot find processing class: " + this.myClassName);
            }
            catch (NoSuchMethodException e) {
                this.myHandler.emitError("Post Processing Error", "Processing class does not have 'run' method: " + this.myClassName);
            }
            catch (IllegalAccessException e) {
                this.myHandler.emitError("Post Processing Error", "Error accessing processing class: " + this.myClassName);
            }
            catch (InvocationTargetException e) {
                this.myHandler.emitError("Post Processing Error", "Invocation Problem calling : " + this.myClassName + ", " + e.getCause().getMessage());
            }
            catch (Exception e) {
                this.myHandler.emitError("Post Processing Error", "Exception when running processing class: " + this.myClassName + ", " + e.getMessage());
            }
            catch (Error e) {
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + e.getMessage());
            }
            catch (Throwable e) {
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + e.getMessage());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutableFile
    implements Processable {
        private String filename;
        private List<String> arguments;
        protected AbstractUIProcessHandler handler;

        public ExecutableFile(String fn, List<String> args) {
            this.filename = fn;
            this.arguments = args;
        }

        @Override
        public boolean run(AbstractUIProcessHandler handler, VariableSubstitutor vs) {
            this.handler = handler;
            String[] params = new String[this.arguments.size() + 1];
            params[0] = vs.substitute(this.filename, "plain");
            int i = 1;
            for (String argument : this.arguments) {
                params[i++] = vs.substitute(argument, "plain");
            }
            try {
                Process p = Runtime.getRuntime().exec(params);
                OutputMonitor stdoutMon = new OutputMonitor(this.handler, p.getInputStream(), false);
                OutputMonitor stderrMon = new OutputMonitor(this.handler, p.getErrorStream(), true);
                Thread stdoutThread = new Thread(stdoutMon);
                Thread stderrThread = new Thread(stderrMon);
                stdoutThread.setDaemon(true);
                stderrThread.setDaemon(true);
                stdoutThread.start();
                stderrThread.start();
                try {
                    int exitStatus = p.waitFor();
                    this.stopMonitor(stdoutMon, stdoutThread);
                    this.stopMonitor(stderrMon, stderrThread);
                    if (exitStatus != 0) {
                        this.handler.emitError("Process execution failure", "The process has returned an error.");
                        return false;
                    }
                }
                catch (InterruptedException ie) {
                    p.destroy();
                    this.handler.emitError("process interrupted", ie.toString());
                    return false;
                }
            }
            catch (IOException ioe) {
                this.handler.emitError("I/O error", ioe.toString());
                return false;
            }
            return true;
        }

        private void stopMonitor(OutputMonitor m, Thread t) {
            m.doStop();
            long softTimeout = 500L;
            try {
                t.join(softTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!t.isAlive()) {
                return;
            }
            t.interrupt();
            long hardTimeout = 500L;
            try {
                t.join(hardTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        public static class OutputMonitor
        implements Runnable {
            private boolean stderr = false;
            private AbstractUIProcessHandler handler;
            private BufferedReader reader;
            private Boolean stop = false;

            public OutputMonitor(AbstractUIProcessHandler handler, InputStream is, boolean stderr) {
                this.stderr = stderr;
                this.reader = new BufferedReader(new InputStreamReader(is));
                this.handler = handler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        this.handler.logOutput(line, this.stderr);
                        if (logfile != null) {
                            logfile.println(line);
                        }
                        Boolean bl = this.stop;
                        synchronized (bl) {
                            if (this.stop.booleanValue()) {
                                return;
                            }
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    this.handler.logOutput(ioe.toString(), true);
                    if (logfile == null) return;
                    logfile.println(ioe.toString());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doStop() {
                Boolean bl = this.stop;
                synchronized (bl) {
                    this.stop = true;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessingJob
    implements Processable {
        public String name;
        private List<Processable> processables;

        public ProcessingJob(String name, List<Processable> processables) {
            this.name = name;
            this.processables = processables;
        }

        @Override
        public boolean run(AbstractUIProcessHandler handler, VariableSubstitutor vs) {
            for (Processable pr : this.processables) {
                if (pr.run(handler, vs)) continue;
                return false;
            }
            return true;
        }
    }

    static interface Processable {
        public boolean run(AbstractUIProcessHandler var1, VariableSubstitutor var2);
    }
}

