/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.UnpackerBase;
import com.izforge.izpack.installer.WebAccessor;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUnpacker
extends UnpackerBase {
    private int progressMeter;

    public WebUnpacker(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        super(idata, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addToInstances();
        try {
            ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
            ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
            ArrayList<UpdateCheck> updatechecks = new ArrayList<UpdateCheck>();
            List packs = this.idata.selectedPacks;
            int npacks = packs.size();
            this.handler.startAction("Unpacking", npacks);
            this.udata = UninstallData.getInstance();
            List[] customActions = this.getCustomActions();
            this.informListeners(customActions, 7, this.idata, npacks, this.handler);
            packs = this.idata.selectedPacks;
            npacks = packs.size();
            for (int i = 0; i < npacks; ++i) {
                String name;
                String tempfile;
                Pack p = (Pack)packs.get(i);
                if (p.hasCondition() && this.rules != null && !this.rules.isConditionTrue(p.getCondition())) continue;
                this.informListeners(customActions, 5, packs.get(i), npacks, this.handler);
                try {
                    tempfile = this.downloadAndVerify(p);
                    this.udata.addFile(tempfile, p.uninstall);
                }
                catch (Exception e) {
                    if ("Cancelled".equals(e.getMessage())) {
                        throw new InstallerException("Installation cancelled", e);
                    }
                    throw new InstallerException("Installation failed. " + e);
                }
                JarFile jarFile = new JarFile(tempfile);
                ZipEntry entry = jarFile.getEntry("metadata");
                InputStream in = jarFile.getInputStream(entry);
                ObjectInputStream objIn = new ObjectInputStream(in);
                int nfiles = objIn.readInt();
                Pack pack = (Pack)packs.get(i);
                String stepname = pack.name;
                if (this.langpack != null && pack.id != null && !"".equals(pack.id) && (name = this.langpack.getString(pack.id)) != null && !"".equals(name)) {
                    stepname = name;
                }
                List<PackFile> filesToWrite = this.getFilesToWrite(objIn, nfiles);
                int progressMeterMax = filesToWrite.size();
                progressMeterMax += 2;
                this.handler.nextStep(stepname, i + 1, filesToWrite.size());
                this.handler.progress(this.progressMeter++, "reading metadata ...");
                int numParsables = objIn.readInt();
                for (int k = 0; k < numParsables; ++k) {
                    ParsableFile pf = (ParsableFile)objIn.readObject();
                    if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) continue;
                    pf.path = IoHelper.translatePath(pf.path, this.vs);
                    parsables.add(pf);
                }
                int numExecutables = objIn.readInt();
                for (int k = 0; k < numExecutables; ++k) {
                    ExecutableFile ef = (ExecutableFile)objIn.readObject();
                    if (ef.hasCondition() && this.rules != null && !this.rules.isConditionTrue(ef.getCondition())) continue;
                    ef.path = IoHelper.translatePath(ef.path, this.vs);
                    if (null != ef.argList && !ef.argList.isEmpty()) {
                        String arg = null;
                        for (int j = 0; j < ef.argList.size(); ++j) {
                            arg = ef.argList.get(j);
                            arg = IoHelper.translatePath(arg, this.vs);
                            ef.argList.set(j, arg);
                        }
                    }
                    executables.add(ef);
                    if (ef.executionStage != 2) continue;
                    this.udata.addExecutable(ef);
                }
                this.handleAdditionalUninstallData(this.udata, customActions);
                int numUpdateChecks = objIn.readInt();
                for (int k = 0; k < numUpdateChecks; ++k) {
                    UpdateCheck uc = (UpdateCheck)objIn.readObject();
                    updatechecks.add(uc);
                }
                objIn.close();
                this.writeFiles(filesToWrite, jarFile, customActions, pack.uninstall);
                if (this.performInterrupted()) {
                    return;
                }
                this.handler.progress(this.progressMeter++, "finalizing ...");
                this.informListeners(customActions, 6, packs.get(i), i, this.handler);
            }
            ScriptParser parser = new ScriptParser(parsables, this.vs);
            parser.parseFiles();
            if (this.performInterrupted()) {
                return;
            }
            FileExecutor executor = new FileExecutor(executables);
            if (executor.executeFiles(0, this.handler) != 0) {
                this.handler.emitError("File execution failed", "The installation was not completed");
                this.result = false;
            }
            if (this.performInterrupted()) {
                return;
            }
            this.putUninstaller();
            this.informListeners(customActions, 8, this.idata, this.handler, null);
            if (this.performInterrupted()) {
                return;
            }
            this.performUpdateChecks(updatechecks);
            if (this.performInterrupted()) {
                return;
            }
            this.writeInstallationInformation();
            this.handler.stopAction();
        }
        catch (Exception err) {
            this.handler.stopAction();
            if ("Installation cancelled".equals(err.getMessage())) {
                this.handler.emitNotification("Installation cancelled");
            } else {
                this.handler.emitError("An error occured", err.getMessage());
                err.printStackTrace();
            }
            this.result = false;
            Housekeeper.getInstance().shutDown(4);
        }
        finally {
            this.removeFromInstances();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadAndVerify(Pack p) throws InstallerException {
        InputStream in;
        File downloadedFile;
        CheckSumObserver cso;
        boolean isLocalInstallation;
        block34: {
            isLocalInstallation = false;
            String baseName = this.idata.info.getInstallerBase();
            String webDirURL = this.idata.info.getWebDirURL();
            if (webDirURL.equals("./")) {
                isLocalInstallation = true;
            }
            cso = null;
            if (p.getDigestLocation() != null && !isLocalInstallation) {
                String locationPath = p.getDigestLocation().toString();
                int index = locationPath.lastIndexOf(".");
                try {
                    cso = new CheckSumObserver(locationPath.substring(index + 1, locationPath.length()));
                }
                catch (NoSuchAlgorithmException ne) {
                    throw new InstallerException("Error processing digest for pack '" + p.name + "'. " + ne.getMessage());
                }
            }
            downloadedFile = null;
            try {
                String packURL;
                if (isLocalInstallation) {
                    packURL = webDirURL + baseName + ".pack-" + p.id + ".jar";
                    downloadedFile = new File(packURL);
                    if (!downloadedFile.exists()) {
                        throw new FileNotFoundException(packURL);
                    }
                    break block34;
                }
                packURL = webDirURL + "/" + baseName + ".pack-" + p.id + ".jar.pack.gz";
                downloadedFile = File.createTempFile("pack-", ".jar.pack.gz");
                WebAccessor w = new WebAccessor(null);
                in = w.openInputStream(new URL(packURL));
                if (in == null) {
                    throw new InstallerException("Unable to retrieve pack at location " + packURL);
                }
                if (cso != null) {
                    BufferedOutputStream out = null;
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(downloadedFile));
                        byte[] buffer = new byte[4096];
                        int length = 0;
                        while (length >= 0) {
                            ((OutputStream)out).write(buffer, 0, length);
                            cso.update(buffer, length);
                            length = in.read(buffer);
                        }
                        break block34;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ignore) {}
                        }
                        if (out != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (IOException ignore) {}
                        }
                    }
                }
                downloadedFile = IoHelper.writeStream(in, downloadedFile);
            }
            catch (Exception ex) {
                throw new InstallerException("Error downloading pack '" + p.name + "'" + "." + ex);
            }
        }
        if (isLocalInstallation) {
            return downloadedFile.getAbsolutePath();
        }
        String expectedChecksum = null;
        if (p.getDigestLocation() != null) {
            int numtries = 3;
            in = null;
            while (in == null && numtries > 0) {
                try {
                    in = p.getDigestLocation().openStream();
                    expectedChecksum = IoHelper.streamToString(in, null);
                }
                catch (ConnectException tryAgain) {
                    System.out.println(tryAgain.getMessage());
                    --numtries;
                }
                catch (Exception ex) {
                    throw new InstallerException("Failed to retrieve digest for pack '" + p.name + "'.", ex);
                }
            }
            if (in == null) {
                throw new InstallerException("Failed to retrieve digest for pack '" + p.name + "'.");
            }
            String actualChecksum = cso.getCheckSum();
            if (!actualChecksum.equals(expectedChecksum)) {
                throw new InstallerException("Message digest comparison failed for pack '" + p.name + "'." + " Found " + actualChecksum + ". Expected " + expectedChecksum);
            }
        }
        File tempFile = null;
        try {
            FileInputStream fin = new FileInputStream(downloadedFile);
            BufferedInputStream in2 = new BufferedInputStream(new GZIPInputStream(fin));
            tempFile = File.createTempFile("pack-", ".jar");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
            JarOutputStream jout = new JarOutputStream(out);
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.unpack((InputStream)in2, jout);
            ((InputStream)in2).close();
            jout.close();
        }
        catch (Exception ex) {
            throw new InstallerException("Error unpacking pack200 file for pack '" + p.name + "'.", ex);
        }
        return tempFile.getAbsolutePath();
    }

    private List<PackFile> getFilesToWrite(ObjectInputStream objIn, int nfiles) throws Exception {
        ArrayList<PackFile> filesToWrite = new ArrayList<PackFile>();
        for (int j = 0; j < nfiles; ++j) {
            PackFile pf = (PackFile)objIn.readObject();
            if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition()) || !OsConstraint.oneMatchesCurrentSystem(pf.osConstraints())) continue;
            String path = IoHelper.translatePath(pf.getTargetPath(), this.vs);
            File pathFile = new File(path);
            if (pf.isDirectory()) continue;
            if (pathFile.exists() && pf.override() != 1) {
                boolean overwritefile = false;
                if (pf.override() != 0) {
                    if (pf.override() == 1) {
                        overwritefile = true;
                    } else if (pf.override() == 4) {
                        overwritefile = pathFile.lastModified() < pf.lastModified();
                    } else {
                        int answer;
                        int def_choice = -1;
                        if (pf.override() == 2) {
                            def_choice = 49;
                        }
                        if (pf.override() == 3) {
                            def_choice = 47;
                        }
                        boolean bl = overwritefile = (answer = this.handler.askQuestion(this.idata.langpack.getString("InstallPanel.overwrite.title") + " - " + pathFile.getName(), this.idata.langpack.getString("InstallPanel.overwrite.question") + pathFile.getAbsolutePath(), 37, def_choice)) == 47;
                    }
                }
                if (!overwritefile) continue;
            }
            filesToWrite.add(pf);
        }
        return filesToWrite;
    }

    private void writeFiles(List<PackFile> filesToWrite, JarFile jarFile, List<?>[] customActions, boolean uninstall) throws Exception {
        for (PackFile pf : filesToWrite) {
            String path = IoHelper.translatePath(pf.getTargetPath(), this.vs);
            File pathFile = new File(path);
            File dir = pathFile.getParentFile();
            if (!dir.exists()) {
                List<?> fileListeners = customActions[customActions.length - 1];
                if (fileListeners != null && fileListeners.size() > 0) {
                    this.mkDirsWithEnhancement(dir, pf, customActions);
                } else if (!dir.mkdirs()) {
                    this.handler.emitError("Error creating directories", "Could not create directory " + dir.getPath());
                    this.handler.stopAction();
                    this.result = false;
                    return;
                }
            }
            this.informListeners(customActions, 1, pathFile, pf, null);
            this.udata.addFile(path, uninstall);
            this.handler.progress(this.progressMeter++, path);
            ZipEntry entry = jarFile.getEntry(pf.getTargetPath());
            IoHelper.writeStream(jarFile.getInputStream(entry), pathFile);
            if (pf.lastModified() >= 0L) {
                pathFile.setLastModified(pf.lastModified());
            }
            this.informListeners(customActions, 2, pathFile, pf, null);
        }
    }

    private static class CheckSumObserver {
        private MessageDigest messageDigest = null;
        private static final int BYTE_MASK = 255;

        public CheckSumObserver(String algorithm) throws NoSuchAlgorithmException {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }

        public void reset() {
            this.messageDigest.reset();
        }

        public void update(byte[] buffer, int length) {
            this.messageDigest.update(buffer, 0, length);
        }

        public String getCheckSum() {
            byte[] digest = this.messageDigest.digest();
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                String temp = Integer.toHexString(digest[i] & 0xFF);
                if (temp.length() == 1) {
                    result.append("0" + temp);
                    continue;
                }
                result.append(temp);
            }
            return result.toString();
        }
    }
}

