/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.InstallationGroupPanelAutomationHelper;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallationGroupPanel
extends IzPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Pack> packsByName;
    private TableModel groupTableModel;
    private JTextPane descriptionField;
    private JScrollPane groupScrollPane;
    private JTable groupsTable;
    private GroupData[] rows;
    private int selectedGroup = -1;

    public InstallationGroupPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        this.buildLayout();
    }

    @Override
    public void panelActivate() {
        this.idata.availablePacks = new ArrayList();
        for (Pack p : this.idata.allPacks) {
            if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
            this.idata.availablePacks.add(p);
        }
        Debug.trace("InstallationGroupPanel.panelActivate, selectedGroup=" + this.selectedGroup);
        HashMap installGroups = this.getInstallGroups(this.idata);
        if (installGroups.size() == 0) {
            super.askQuestion("Skip InstallGroup selection", "Skip InstallGroup selection", 37);
            this.parent.skipPanel();
            return;
        }
        this.groupTableModel = this.getModel(installGroups);
        this.groupsTable.setModel(this.groupTableModel);
        TableColumnModel tcm = this.groupsTable.getColumnModel();
        TableCellRenderer radioButtonRenderer = new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JRadioButton selectedButton;
                if (value == null) {
                    return null;
                }
                int selectedRow = table.getSelectedRow();
                if (selectedRow != -1 && !(selectedButton = (JRadioButton)table.getValueAt(selectedRow, 0)).isSelected()) {
                    selectedButton.doClick();
                }
                JRadioButton button = (JRadioButton)value;
                button.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                button.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return button;
            }
        };
        tcm.getColumn(0).setCellRenderer(radioButtonRenderer);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(4);
        tcm.getColumn(1).setCellRenderer(renderer);
        this.groupsTable.setSelectionMode(0);
        this.groupsTable.getSelectionModel().addListSelectionListener(this);
        this.groupsTable.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.groupsTable.setIntercellSpacing(new Dimension(0, 0));
        this.groupsTable.setShowGrid(false);
        if (this.selectedGroup >= 0) {
            this.groupsTable.getSelectionModel().setSelectionInterval(this.selectedGroup, this.selectedGroup);
            this.descriptionField.setText(this.rows[this.selectedGroup].description);
        } else {
            this.descriptionField.setText(this.rows[0].description);
        }
    }

    @Override
    public void panelDeactivate() {
        Debug.trace("InstallationGroupPanel.panelDeactivate, selectedGroup=" + this.selectedGroup);
        if (this.selectedGroup >= 0) {
            this.removeUnusedPacks();
            GroupData group = this.rows[this.selectedGroup];
            this.idata.setVariable("INSTALL_GROUP", group.name);
            Debug.trace("Added variable INSTALL_GROUP=" + group.name);
        }
    }

    @Override
    public boolean isValidated() {
        Debug.trace("InstallationGroupPanel.isValidated, selectedGroup=" + this.selectedGroup);
        return this.selectedGroup >= 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Debug.trace("valueChanged: " + e);
        if (!e.getValueIsAdjusting()) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                this.descriptionField.setText("");
            } else {
                this.selectedGroup = lsm.getMinSelectionIndex();
                if (this.selectedGroup >= 0) {
                    GroupData data = this.rows[this.selectedGroup];
                    this.descriptionField.setText(data.description);
                    ((JRadioButton)this.groupTableModel.getValueAt(this.selectedGroup, 0)).setSelected(true);
                }
                Debug.trace("selectedGroup set to: " + this.selectedGroup);
            }
        }
    }

    @Override
    public void makeXMLData(XMLElement panelRoot) {
        InstallationGroupPanelAutomationHelper helper = new InstallationGroupPanelAutomationHelper();
        this.idata.setAttribute("GroupData", this.rows);
        this.idata.setAttribute("packsByName", this.packsByName);
        helper.makeXMLData(this.idata, panelRoot);
    }

    protected void buildLayout() {
        this.descriptionField = new JTextPane();
        this.groupScrollPane = new JScrollPane();
        this.groupsTable = new JTable();
        this.setLayout(new GridBagLayout());
        this.descriptionField.setMargin(new Insets(2, 2, 2, 2));
        this.descriptionField.setAlignmentX(0.0f);
        this.descriptionField.setCaretPosition(0);
        this.descriptionField.setEditable(false);
        this.descriptionField.setOpaque(false);
        this.descriptionField.setText("<b>Install group description text</b>");
        this.descriptionField.setContentType("text/html");
        this.descriptionField.setBorder(new TitledBorder(this.idata.langpack.getString("PacksPanel.description")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.add((Component)this.descriptionField, gridBagConstraints);
        this.groupScrollPane.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.groupScrollPane.setViewportView(this.groupsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.groupScrollPane, gridBagConstraints);
    }

    protected void removeUnusedPacks() {
        GroupData data = this.rows[this.selectedGroup];
        Debug.trace("InstallationGroupPanel.removeUnusedPacks, GroupData=" + data.name);
        Iterator iter = this.idata.availablePacks.iterator();
        while (iter.hasNext()) {
            Pack p = (Pack)iter.next();
            p.revDependencies = null;
            if (data.packNames.contains(p.name)) continue;
            iter.remove();
            Debug.trace("Removed AvailablePack: " + p.name);
        }
        this.idata.selectedPacks.clear();
        if (!"no".equals(this.idata.getVariable("InstallationGroupPanel.selectPacks"))) {
            this.idata.selectedPacks.addAll(this.idata.availablePacks);
        } else {
            for (Object availablePack : this.idata.availablePacks) {
                Pack p = (Pack)availablePack;
                if (!p.preselected) continue;
                this.idata.selectedPacks.add(p);
            }
        }
    }

    protected void addDependents(Pack p, HashMap<String, Pack> packsByName, GroupData data) {
        data.packNames.add(p.name);
        data.size += p.nbytes;
        Debug.trace("addDependents, added pack: " + p.name);
        if (p.dependencies == null || p.dependencies.size() == 0) {
            return;
        }
        Iterator<String> iter = p.dependencies.iterator();
        Debug.trace(p.name + " dependencies: " + p.dependencies);
        while (iter.hasNext()) {
            String dependent = iter.next();
            if (data.packNames.contains(dependent)) continue;
            Debug.trace("Need dependent: " + dependent);
            Pack dependentPack = packsByName.get(dependent);
            this.addDependents(dependentPack, packsByName, data);
        }
    }

    protected HashMap getInstallGroups(InstallData idata) {
        this.packsByName = new HashMap();
        HashMap<String, GroupData> installGroups = new HashMap<String, GroupData>();
        for (int n = 0; n < idata.availablePacks.size(); ++n) {
            Pack p = (Pack)idata.availablePacks.get(n);
            this.packsByName.put(p.name, p);
            Set<String> groups = p.installGroups;
            Iterator<String> iter = groups.iterator();
            Debug.trace("Pack: " + p.name + ", installGroups: " + groups);
            while (iter.hasNext()) {
                String group = iter.next();
                GroupData data = (GroupData)installGroups.get(group);
                if (data != null) continue;
                String description = this.getGroupDescription(group);
                String sortKey = this.getGroupSortKey(group);
                data = new GroupData(group, description, sortKey);
                installGroups.put(group, data);
            }
        }
        Debug.trace("Found installGroups: " + installGroups.keySet());
        for (GroupData data : installGroups.values()) {
            Debug.trace("Adding dependents for: " + data.name);
            for (Pack p : idata.availablePacks) {
                Set<String> groups = p.installGroups;
                if (groups.size() != 0 && !groups.contains(data.name) || data.packNames.contains(p.name)) continue;
                this.addDependents(p, this.packsByName, data);
            }
            Debug.trace("Completed dependents for: " + data);
            if (!Debug.tracing()) continue;
            Debug.trace(data);
        }
        return installGroups;
    }

    protected String getGroupDescription(String group) {
        String description = null;
        String key = "InstallationGroupPanel.description." + group;
        if (this.idata.langpack != null) {
            String html;
            String htmlKey = key + ".html";
            description = htmlKey.equalsIgnoreCase(html = this.idata.langpack.getString(htmlKey)) ? this.idata.langpack.getString(key) : html;
        }
        if (description == null || key.equalsIgnoreCase(description)) {
            description = this.idata.getVariable(key);
        }
        if (description == null) {
            description = group + " installation";
        }
        try {
            description = URLDecoder.decode(description, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.emitWarning("Failed to convert description", e.getMessage());
        }
        return description;
    }

    protected String getGroupSortKey(String group) {
        String key = "InstallationGroupPanel.sortKey." + group;
        String sortKey = this.idata.getVariable(key);
        if (sortKey == null) {
            sortKey = group;
        }
        try {
            sortKey = URLDecoder.decode(sortKey, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.emitWarning("Failed to convert sortKey", e.getMessage());
        }
        return sortKey;
    }

    protected String getLocalizedGroupName(String group) {
        String gname = null;
        String key = "InstallationGroupPanel.group." + group;
        if (this.idata.langpack != null) {
            String html;
            String htmlKey = key + ".html";
            gname = htmlKey.equalsIgnoreCase(html = this.idata.langpack.getString(htmlKey)) ? this.idata.langpack.getString(key) : html;
        }
        if (gname == null || key.equalsIgnoreCase(gname)) {
            gname = this.idata.getVariable(key);
        }
        if (gname == null) {
            gname = group;
        }
        try {
            gname = URLDecoder.decode(gname, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.emitWarning("Failed to convert localized group name", e.getMessage());
        }
        return gname;
    }

    protected TableModel getModel(HashMap groupData) {
        String c1 = this.parent.langpack.getString("InstallationGroupPanel.colNameSelected");
        String c3 = this.parent.langpack.getString("InstallationGroupPanel.colNameSize");
        Object[] columns = new String[]{c1, c3};
        DefaultTableModel model = new DefaultTableModel(columns, 0){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.rows = new GroupData[groupData.size()];
        String defaultGroup = this.idata.getVariable("InstallationGroupPanel.defaultGroup");
        Debug.trace("InstallationGroupPanel.defaultGroup=" + defaultGroup + ", selectedGroup=" + this.selectedGroup);
        ArrayList values = new ArrayList(groupData.values());
        Collections.sort(values, new Comparator(){

            public int compare(Object o1, Object o2) {
                GroupData g1 = (GroupData)o1;
                GroupData g2 = (GroupData)o2;
                if (g1.sortKey == null || g2.sortKey == null) {
                    return 0;
                }
                return g1.sortKey.compareTo(g2.sortKey);
            }
        });
        Iterator iter = values.iterator();
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean madeSelection = false;
        int count = 0;
        while (iter.hasNext()) {
            GroupData gd;
            this.rows[count] = gd = (GroupData)iter.next();
            Debug.trace("Creating button#" + count + ", group=" + gd.name);
            JRadioButton btn = new JRadioButton(this.getLocalizedGroupName(gd.name));
            if (this.selectedGroup == count) {
                btn.setSelected(true);
                Debug.trace("Selected button#" + count);
            } else if (this.selectedGroup < 0 && !madeSelection) {
                if (defaultGroup != null) {
                    if (defaultGroup.equals(gd.name)) {
                        madeSelection = true;
                    }
                } else if (count == 0) {
                    madeSelection = true;
                }
                if (madeSelection) {
                    btn.setSelected(true);
                    Debug.trace("Selected button#" + count);
                    this.selectedGroup = count;
                }
            } else {
                btn.setSelected(false);
            }
            buttonGroup.add(btn);
            String sizeText = gd.getSizeString();
            Object[] data = new Object[]{btn, sizeText};
            model.addRow(data);
            ++count;
        }
        return model;
    }

    protected static class GroupData {
        static final long ONEK = 1024L;
        static final long ONEM = 0x100000L;
        static final long ONEG = 0x40000000L;
        String name;
        String description;
        String sortKey;
        long size;
        HashSet<String> packNames = new HashSet();

        GroupData(String name, String description, String sortKey) {
            this.name = name;
            this.description = description;
            this.sortKey = sortKey;
        }

        String getSizeString() {
            String s = this.size < 1024L ? this.size + " bytes" : (this.size < 0x100000L ? this.size / 1024L + " KB" : (this.size < 0x40000000L ? this.size / 0x100000L + " MB" : this.size / 0x40000000L + " GB"));
            return s;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer("GroupData(");
            tmp.append(this.name);
            tmp.append("){description=");
            tmp.append(this.description);
            tmp.append(", sortKey=");
            tmp.append(this.sortKey);
            tmp.append(", size=");
            tmp.append(this.size);
            tmp.append(", sizeString=");
            tmp.append(this.getSizeString());
            tmp.append(", packNames=");
            tmp.append(this.packNames);
            tmp.append("}");
            return tmp.toString();
        }
    }
}

