/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.panels.InstallationGroupPanel;
import com.izforge.izpack.util.Debug;
import java.util.HashMap;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class InstallationGroupPanelAutomationHelper
implements PanelAutomation {
    public void makeXMLData(AutomatedInstallData idata, XMLElement panelRoot) {
        InstallationGroupPanel.GroupData[] rows = (InstallationGroupPanel.GroupData[])idata.getAttribute("GroupData");
        HashMap packsByName = (HashMap)idata.getAttribute("packsByName");
        for (InstallationGroupPanel.GroupData gd : rows) {
            XMLElement xgroup = new XMLElement("group");
            xgroup.setAttribute("name", gd.name);
            for (String name : gd.packNames) {
                Pack pack = (Pack)packsByName.get(name);
                int index = idata.availablePacks.indexOf(pack);
                XMLElement xpack = new XMLElement("pack");
                xpack.setAttribute("name", name);
                xpack.setAttribute("index", "" + index);
                xgroup.addChild(xpack);
            }
            panelRoot.addChild(xgroup);
        }
    }

    public boolean runAutomated(AutomatedInstallData idata, XMLElement panelRoot) {
        String installGroup = idata.getVariable("INSTALL_GROUP");
        Debug.trace("InstallationGroupPanelAutomationHelper: runAutomated, INSTALL_GROUP: " + installGroup);
        if (installGroup != null) {
            Vector<XMLElement> groups = panelRoot.getChildrenNamed("group");
            for (XMLElement group : groups) {
                String name = group.getAttribute("name");
                Debug.trace("InstallationGroupPanelAutomationHelper: Checking INSTALL_GROUP against: " + name);
                if (!name.equalsIgnoreCase(installGroup)) continue;
                Debug.trace("Found INSTALL_GROUP match for: " + installGroup);
                idata.selectedPacks.clear();
                Vector<XMLElement> packs = group.getChildrenNamed("pack");
                Debug.trace(name + " pack count: " + packs.size());
                Debug.trace("Available pack count: " + idata.availablePacks.size());
                for (XMLElement xpack : packs) {
                    String pname = xpack.getAttribute("name");
                    String indexStr = xpack.getAttribute("index");
                    int index = Integer.parseInt(indexStr);
                    if (index < 0) continue;
                    Pack pack = (Pack)idata.availablePacks.get(index);
                    idata.selectedPacks.add(pack);
                    Debug.trace("Added pack: " + pack.name);
                }
                Debug.trace("Set selectedPacks to: " + idata.selectedPacks);
                break;
            }
        }
        return true;
    }
}

