/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class InstallationTypePanel
extends IzPanel
implements ActionListener {
    private JRadioButton normalinstall;
    private JRadioButton modifyinstall;
    private static final long serialVersionUID = -8178770882900584122L;

    public InstallationTypePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.buildGUI();
    }

    private void buildGUI() {
        this.add((Component)LabelFactory.create(this.parent.langpack.getString("InstallationTypePanel.info"), this.parent.icons.getImageIcon("history"), 10), "nextLine");
        ButtonGroup group = new ButtonGroup();
        boolean modifyinstallation = Boolean.valueOf(this.idata.getVariable("modify.izpack.install"));
        this.normalinstall = new JRadioButton(this.parent.langpack.getString("InstallationTypePanel.normal"), !modifyinstallation);
        this.normalinstall.addActionListener(this);
        group.add(this.normalinstall);
        this.add((Component)this.normalinstall, "nextLine");
        this.modifyinstall = new JRadioButton(this.parent.langpack.getString("InstallationTypePanel.modify"), modifyinstallation);
        this.modifyinstall.addActionListener(this);
        group.add(this.modifyinstall);
        this.add((Component)this.modifyinstall, "nextLine");
        this.setInitialFocus(this.normalinstall);
        this.getLayoutHelper().completeLayout();
    }

    public void panelActivate() {
        boolean modifyinstallation = Boolean.valueOf(this.idata.getVariable("modify.izpack.install"));
        if (modifyinstallation) {
            this.modifyinstall.setSelected(true);
        } else {
            this.normalinstall.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Debug.trace("installation type changed");
        if (e.getSource() == this.normalinstall) {
            Debug.trace("normal installation");
            this.idata.setVariable("modify.izpack.install", "false");
        } else {
            Debug.trace("modification installation");
            this.idata.setVariable("modify.izpack.install", "true");
        }
    }
}

