/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.ImgPacksPanelAutomationHelper;
import com.izforge.izpack.panels.PacksModel;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.n3.nanoxml.XMLElement;

public abstract class PacksPanelBase
extends IzPanel
implements PacksPanelInterface,
ListSelectionListener {
    protected JLabel freeSpaceLabel;
    protected JLabel spaceLabel;
    protected JTextArea descriptionArea;
    protected JTextArea dependencyArea;
    protected JTable packsTable;
    protected PacksModel packsModel;
    protected JScrollPane tableScroller;
    private Map<String, Pack> names;
    protected long bytes = 0L;
    protected long freeBytes = 0L;
    protected boolean dependenciesExist = false;
    private LocaleDatabase langpack = null;
    private static final String LANG_FILE_NAME = "packsLang.xml";
    private Debugger debugger;

    public PacksPanelBase(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        try {
            this.langpack = parent.langpack;
            InputStream inputStream = ResourceManager.getInstance().getInputStream(LANG_FILE_NAME);
            this.langpack.add(inputStream);
            this.debugger = parent.getDebugger();
        }
        catch (Throwable exception) {
            Debug.trace(exception);
        }
        this.computePacks(idata.availablePacks);
        this.createNormalLayout();
    }

    protected abstract void createNormalLayout();

    public LocaleDatabase getLangpack() {
        return this.langpack;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public void showSpaceRequired() {
        if (this.spaceLabel != null) {
            this.spaceLabel.setText(Pack.toByteUnitsString(this.bytes));
        }
    }

    public void showFreeSpace() {
        if (IoHelper.supported("getFreeSpace") && this.freeSpaceLabel != null) {
            this.freeBytes = IoHelper.getFreeSpace(IoHelper.existingParent(new File(this.idata.getInstallPath())).getAbsolutePath());
            String msg = this.freeBytes < 0L ? this.parent.langpack.getString("PacksPanel.notAscertainable") : Pack.toByteUnitsString(this.freeBytes);
            this.freeSpaceLabel.setText(msg);
        }
    }

    public boolean isValidated() {
        if (IoHelper.supported("getFreeSpace") && this.freeBytes >= 0L && this.freeBytes <= this.bytes) {
            JOptionPane.showMessageDialog(this, this.parent.langpack.getString("PacksPanel.notEnoughSpace"), this.parent.langpack.getString("installer.error"), 0);
            return false;
        }
        return true;
    }

    public void makeXMLData(XMLElement panelRoot) {
        new ImgPacksPanelAutomationHelper().makeXMLData(this.idata, panelRoot);
    }

    public void valueChanged(ListSelectionEvent e) {
        Pack pack;
        int selectedRow = this.packsTable.getSelectedRow();
        if (this.descriptionArea != null && selectedRow != -1) {
            pack = (Pack)this.idata.availablePacks.get(selectedRow);
            String desc = "";
            String key = pack.id + ".description";
            if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                desc = this.langpack.getString(key);
            }
            if ("".equals(desc) || key.equals(desc)) {
                desc = pack.description;
            }
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            desc = vs.substitute(desc, null);
            this.descriptionArea.setText(desc);
        }
        if (this.dependencyArea != null && selectedRow != -1) {
            pack = (Pack)this.idata.availablePacks.get(selectedRow);
            List<String> dep = pack.dependencies;
            String list = "";
            if (dep != null) {
                list = list + (this.langpack == null ? "Dependencies: " : this.langpack.getString("PacksPanel.dependencies"));
            }
            for (int j = 0; dep != null && j < dep.size(); ++j) {
                String name = dep.get(j);
                list = list + this.getI18NPackName(this.names.get(name));
                if (j == dep.size() - 1) continue;
                list = list + ", ";
            }
            String excludeslist = this.langpack == null ? "Excludes: " : this.langpack.getString("PacksPanel.excludes");
            int numexcludes = 0;
            if (pack.excludeGroup != null) {
                for (int q = 0; q < this.idata.availablePacks.size(); ++q) {
                    Pack otherpack = (Pack)this.idata.availablePacks.get(q);
                    String exgroup = otherpack.excludeGroup;
                    if (exgroup == null || q == selectedRow || !pack.excludeGroup.equals(exgroup)) continue;
                    excludeslist = excludeslist + this.getI18NPackName(otherpack) + ", ";
                    ++numexcludes;
                }
            }
            if (dep != null) {
                excludeslist = "    " + excludeslist;
            }
            if (numexcludes > 0) {
                list = list + excludeslist;
            }
            if (list.endsWith(", ")) {
                list = list.substring(0, list.length() - 2);
            }
            this.dependencyArea.setText(list);
        }
    }

    private String getI18NPackName(Pack pack) {
        String packName = pack.name;
        String key = pack.id;
        if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
            packName = this.langpack.getString(key);
        }
        if ("".equals(packName) || key == null || key.equals(packName)) {
            packName = pack.name;
        }
        return packName;
    }

    protected JLabel createLabel(String msgId, String iconId, GridBagLayout layout, GridBagConstraints constraints) {
        JLabel label = LabelFactory.create(this.parent.langpack.getString(msgId), this.parent.icons.getImageIcon(iconId), 11);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(label, constraints);
        }
        this.add(label);
        return label;
    }

    protected JLabel createPanelWithLabel(String msgId, GridBagLayout layout, GridBagConstraints constraints) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        panel.setAlignmentX(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(LabelFactory.create(this.parent.langpack.getString(msgId)));
        panel.add(Box.createHorizontalGlue());
        panel.add(label);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(panel, constraints);
        }
        this.add(panel);
        return label;
    }

    protected JTextArea createTextArea(String msgId, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTextArea area = new JTextArea();
        area.setAlignmentX(0.0f);
        area.setCaretPosition(0);
        area.setEditable(false);
        area.setEditable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString(msgId)));
        area.setFont(this.getControlTextFont());
        if (layout != null && constraints != null) {
            if (scroller != null) {
                layout.addLayoutComponent(scroller, constraints);
            } else {
                layout.addLayoutComponent(area, constraints);
            }
        }
        if (scroller != null) {
            scroller.setViewportView(area);
            this.add(scroller);
        } else {
            this.add(area);
        }
        return area;
    }

    protected JTable createPacksTable(int width, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTable table = new JTable();
        table.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        table.setIntercellSpacing(new Dimension(0, 0));
        table.setBackground(Color.white);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(this);
        table.setShowGrid(false);
        scroller.setViewportView(table);
        scroller.setAlignmentX(0.0f);
        scroller.getViewport().setBackground(Color.white);
        scroller.setPreferredSize(new Dimension(width, this.idata.guiPrefs.height / 3 + 30));
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(scroller, constraints);
        }
        this.add(scroller);
        return table;
    }

    private void computePacks(List packs) {
        this.names = new HashMap<String, Pack>();
        this.dependenciesExist = false;
        for (Object pack1 : packs) {
            Pack pack = (Pack)pack1;
            this.names.put(pack.name, pack);
            if (pack.dependencies == null && pack.excludeGroup == null) continue;
            this.dependenciesExist = true;
        }
    }

    public void panelActivate() {
        try {
            this.packsModel = new PacksModel(this, this.idata, this.parent.getRules()){

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            this.packsTable.setModel(this.packsModel);
            CheckBoxRenderer packSelectedRenderer = new CheckBoxRenderer();
            this.packsTable.getColumnModel().getColumn(0).setCellRenderer(packSelectedRenderer);
            this.packsTable.getColumnModel().getColumn(0).setMaxWidth(40);
            this.packsTable.getColumnModel().getColumn(1).setCellRenderer(new PacksPanelTableCellRenderer());
            PacksPanelTableCellRenderer packTextColumnRenderer = new PacksPanelTableCellRenderer();
            packTextColumnRenderer.setHorizontalAlignment(4);
            this.packsTable.getColumnModel().getColumn(2).setCellRenderer(packTextColumnRenderer);
            this.packsTable.getColumnModel().getColumn(2).setMaxWidth(100);
            this.packsTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent event) {
                    int row = PacksPanelBase.this.packsTable.rowAtPoint(event.getPoint());
                    int col = PacksPanelBase.this.packsTable.columnAtPoint(event.getPoint());
                    if (col == 0) {
                        Integer checked = (Integer)PacksPanelBase.this.packsModel.getValueAt(row, 0);
                        checked = checked == 0 ? 1 : 0;
                        PacksPanelBase.this.packsModel.setValueAt(checked, row, 0);
                        PacksPanelBase.this.packsTable.repaint();
                    }
                }
            });
            this.tableScroller.remove(this.packsTable.getTableHeader());
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            Iterator iter = this.idata.availablePacks.iterator();
            this.bytes = 0L;
            while (iter.hasNext()) {
                Pack p = (Pack)iter.next();
                if (p.required) {
                    this.bytes += p.nbytes;
                    continue;
                }
                if (!this.idata.selectedPacks.contains(p)) continue;
                this.bytes += p.nbytes;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showSpaceRequired();
        this.showFreeSpace();
        this.packsTable.setRowSelectionInterval(0, 0);
    }

    public String getSummaryBody() {
        StringBuffer retval = new StringBuffer(256);
        Iterator<Object> iter = this.idata.selectedPacks.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (!first) {
                retval.append("<br>");
            }
            first = false;
            Pack pack = (Pack)iter.next();
            if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                retval.append(this.langpack.getString(pack.id));
                continue;
            }
            retval.append(pack.name);
        }
        if (this.packsModel.isModifyinstallation()) {
            Map installedpacks = this.packsModel.getInstalledpacks();
            iter = installedpacks.keySet().iterator();
            retval.append("<br><b>");
            retval.append(this.langpack.getString("PacksPanel.installedpacks.summarycaption"));
            retval.append("</b>");
            retval.append("<br>");
            while (iter.hasNext()) {
                Pack pack = (Pack)installedpacks.get(iter.next());
                if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                    retval.append(this.langpack.getString(pack.id));
                } else {
                    retval.append(pack.name);
                }
                retval.append("<br>");
            }
        }
        return retval.toString();
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    static class PacksPanelTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -9089892183236584242L;

        PacksPanelTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int state = (Integer)table.getModel().getValueAt(row, 0);
            if (state == -2) {
                renderer.setForeground(Color.GRAY);
                if (isSelected) {
                    renderer.setBackground(table.getSelectionBackground());
                } else {
                    renderer.setBackground(table.getBackground());
                }
            } else if (isSelected) {
                renderer.setForeground(table.getSelectionForeground());
                renderer.setBackground(table.getSelectionBackground());
            } else {
                renderer.setForeground(table.getForeground());
                renderer.setBackground(table.getBackground());
            }
            return renderer;
        }
    }

    public static class LFIndependentIcon
    implements Icon {
        ButtonModel buttonModel = null;

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model;
            this.buttonModel = model = ((JCheckBox)c).getModel();
            int controlSize = this.getControlSize();
            if (model.isPressed() && model.isArmed()) {
                g.setColor(MetalLookAndFeel.getControlShadow());
                if (model.isEnabled()) {
                    g.setColor(Color.green);
                } else {
                    g.setColor(Color.gray);
                }
                g.fillRect(x, y, controlSize - 1, controlSize - 1);
                this.drawPressedBorder(g, x, y, controlSize, controlSize, model);
            } else {
                this.drawBorder(g, x, y, controlSize, controlSize, model);
            }
            g.setColor(Color.green);
            if (model.isSelected()) {
                this.drawCheck(g, x, y);
            }
        }

        private void drawBorder(Graphics g, int x, int y, int w, int h, ButtonModel model) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            if (!model.isEnabled()) {
                g.setColor(new Color(0.4f, 0.4f, 0.4f));
            }
            g.drawRect(0, 0, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            if (!model.isEnabled()) {
                g.setColor(new Color(0.6f, 0.6f, 0.6f));
            }
            g.drawRect(1, 1, w - 2, h - 2);
            if (model.isEnabled()) {
                g.setColor(Color.white);
            } else {
                g.setColor(new Color(0.8f, 0.8f, 0.8f));
            }
            g.fillRect(2, 2, w - 3, h - 3);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(0, h - 1, 1, h - 2);
            g.drawLine(w - 1, 0, w - 2, 1);
            g.translate(-x, -y);
        }

        private void drawPressedBorder(Graphics g, int x, int y, int w, int h, ButtonModel model) {
            g.translate(x, y);
            this.drawBorder(g, 0, 0, w, h, model);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(1, 1, 1, h - 2);
            g.drawLine(1, 1, w - 2, 1);
            g.drawLine(2, 2, 2, h - 3);
            g.drawLine(2, 2, w - 3, 2);
            g.translate(-x, -y);
        }

        protected void drawCheck(Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            if (this.buttonModel != null) {
                if (this.buttonModel.isEnabled()) {
                    g.setColor(new Color(0.0f, 0.6f, 0.0f));
                } else {
                    g.setColor(new Color(0.1f, 0.1f, 0.1f));
                }
            }
            g.drawLine(x + (controlSize - 4), y + 2, x + (controlSize - 4) - 4, y + 2 + 4);
            g.drawLine(x + (controlSize - 4), y + 3, x + (controlSize - 4) - 4, y + 3 + 4);
            g.drawLine(x + (controlSize - 4), y + 4, x + (controlSize - 4) - 4, y + 4 + 4);
            g.drawLine(x + (controlSize - 4) - 4, y + 2 + 4, x + (controlSize - 4) - 4 - 2, y + 2 + 4 - 2);
            g.drawLine(x + (controlSize - 4) - 4, y + 3 + 4, x + (controlSize - 4) - 4 - 2, y + 3 + 4 - 2);
            g.drawLine(x + (controlSize - 4) - 4, y + 4 + 4, x + (controlSize - 4) - 4 - 2, y + 4 + 4 - 2);
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    static class CheckBoxRenderer
    implements TableCellRenderer {
        JCheckBox checkbox = new JCheckBox();

        CheckBoxRenderer() {
            if (OsVersion.IS_UNIX && !OsVersion.IS_OSX) {
                this.checkbox.setIcon(new LFIndependentIcon());
                this.checkbox.setDisabledIcon(new LFIndependentIcon());
                this.checkbox.setSelectedIcon(new LFIndependentIcon());
                this.checkbox.setDisabledSelectedIcon(new LFIndependentIcon());
            }
            this.checkbox.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.checkbox.setForeground(table.getSelectionForeground());
                this.checkbox.setBackground(table.getSelectionBackground());
            } else {
                this.checkbox.setForeground(table.getForeground());
                this.checkbox.setBackground(table.getBackground());
            }
            int state = (Integer)value;
            if (state == -2) {
                this.checkbox.setForeground(Color.GRAY);
            }
            if (state == -3) {
                this.checkbox.setForeground(Color.RED);
                this.checkbox.setSelected(true);
            }
            this.checkbox.setEnabled(state >= 0);
            this.checkbox.setSelected(value != null && Math.abs(state) == 1);
            return this.checkbox;
        }
    }
}

