/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextInputField
extends JComponent
implements ProcessingClient {
    private static final long serialVersionUID = 8611515659787697087L;
    private Map<String, String> validatorParams;
    private Validator validationService;
    private JTextField field;
    private boolean hasParams = false;

    public TextInputField(String set, int size, String validator, Map<String, String> validatorParams) {
        this(set, size, validator);
        this.validatorParams = validatorParams;
        this.hasParams = true;
    }

    public TextInputField(String set, int size, String validator) {
        try {
            if (validator != null) {
                Debug.trace("Making Validator for: " + validator);
                this.validationService = (Validator)Class.forName(validator).newInstance();
            }
        }
        catch (Throwable exception) {
            this.validationService = null;
            Debug.trace(exception);
        }
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(3);
        layout.setVgap(0);
        this.setLayout(layout);
        this.field = new JTextField(set, size);
        this.field.setCaretPosition(0);
        this.add(this.field);
    }

    @Override
    public Map<String, String> getValidatorParams() {
        return this.validatorParams;
    }

    @Override
    public String getText() {
        return this.field.getText();
    }

    public void setText(String value) {
        this.field.setText(value);
    }

    @Override
    public String getFieldContents(int index) {
        return this.field.getText();
    }

    @Override
    public int getNumFields() {
        return 1;
    }

    public boolean validateContents() {
        if (this.validationService != null) {
            Debug.trace("Validating contents");
            return this.validationService.validate(this);
        }
        Debug.trace("Not validating contents");
        return true;
    }

    @Override
    public boolean hasParams() {
        return this.hasParams;
    }
}

