/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.WebAccessor;
import com.izforge.izpack.panels.CheckBoxNode;
import com.izforge.izpack.panels.CheckBoxNodeRenderer;
import com.izforge.izpack.panels.CheckTreeController;
import com.izforge.izpack.panels.ImgPacksPanelAutomationHelper;
import com.izforge.izpack.panels.PacksModel;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import net.n3.nanoxml.XMLElement;

public class TreePacksPanel
extends IzPanel
implements PacksPanelInterface {
    private static final long serialVersionUID = 5684716698930628262L;
    protected JLabel freeSpaceLabel;
    protected JLabel spaceLabel;
    protected JTextArea descriptionArea;
    protected JTextArea dependencyArea;
    protected JTree packsTree;
    protected PacksModel packsModel;
    protected JScrollPane tableScroller;
    private Map<String, Pack> names;
    protected long bytes = 0L;
    protected long freeBytes = 0L;
    protected boolean dependenciesExist = false;
    private LocaleDatabase langpack = null;
    private static final String LANG_FILE_NAME = "packsLang.xml";
    private HashMap<String, Pack> idToPack;
    private HashMap<String, ArrayList<String>> treeData;
    private HashMap<Pack, Integer> packToRowNumber;
    private HashMap<String, CheckBoxNode> idToCheckBoxNode = new HashMap();
    private CheckTreeController checkTreeController;

    public TreePacksPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        try {
            InputStream langPackStream;
            this.langpack = parent.langpack;
            String webdir = idata.info.getWebDirURL();
            if (webdir != null) {
                try {
                    URL url = new URL(webdir + "/langpacks/" + LANG_FILE_NAME + idata.localeISO3);
                    langPackStream = new WebAccessor(null).openInputStream(url);
                }
                catch (Exception e) {
                    langPackStream = ResourceManager.getInstance().getInputStream(LANG_FILE_NAME);
                }
            } else {
                langPackStream = ResourceManager.getInstance().getInputStream(LANG_FILE_NAME);
            }
            this.langpack.add(langPackStream);
            langPackStream.close();
        }
        catch (Throwable exception) {
            Debug.trace(exception);
        }
        this.computePacks(idata.availablePacks);
    }

    protected void createNormalLayout() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.createLabel("PacksPanel.info", "preferences", null, null);
        this.add(Box.createRigidArea(new Dimension(0, 3)));
        this.createLabel("PacksPanel.tip", "tip", null, null);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.tableScroller = new JScrollPane();
        this.packsTree = this.createPacksTree(300, this.tableScroller, null, null);
        if (this.dependenciesExist) {
            this.dependencyArea = this.createTextArea("PacksPanel.dependencyList", null, null, null);
        }
        this.descriptionArea = this.createTextArea("PacksPanel.description", null, null, null);
        this.spaceLabel = this.createPanelWithLabel("PacksPanel.space", null, null);
        if (IoHelper.supported("getFreeSpace")) {
            this.add(Box.createRigidArea(new Dimension(0, 3)));
            this.freeSpaceLabel = this.createPanelWithLabel("PacksPanel.freespace", null, null);
        }
    }

    public LocaleDatabase getLangpack() {
        return this.langpack;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public void showSpaceRequired() {
        if (this.spaceLabel != null) {
            this.spaceLabel.setText(Pack.toByteUnitsString(this.bytes));
        }
    }

    public void showFreeSpace() {
        if (IoHelper.supported("getFreeSpace") && this.freeSpaceLabel != null) {
            String msg = null;
            this.freeBytes = IoHelper.getFreeSpace(IoHelper.existingParent(new File(this.idata.getInstallPath())).getAbsolutePath());
            msg = this.freeBytes < 0L ? this.parent.langpack.getString("PacksPanel.notAscertainable") : Pack.toByteUnitsString(this.freeBytes);
            this.freeSpaceLabel.setText(msg);
        }
    }

    public Debugger getDebugger() {
        return null;
    }

    public boolean isValidated() {
        this.refreshPacksToInstall();
        if (IoHelper.supported("getFreeSpace") && this.freeBytes >= 0L && this.freeBytes <= this.bytes) {
            JOptionPane.showMessageDialog(this, this.parent.langpack.getString("PacksPanel.notEnoughSpace"), this.parent.langpack.getString("installer.error"), 0);
            return false;
        }
        return true;
    }

    public void makeXMLData(XMLElement panelRoot) {
        new ImgPacksPanelAutomationHelper().makeXMLData(this.idata, panelRoot);
    }

    private String getI18NPackName(Pack pack) {
        String packName = pack.name;
        String key = pack.id;
        if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
            packName = this.langpack.getString(key);
        }
        if ("".equals(packName) || key == null || key.equals(packName)) {
            packName = pack.name;
        }
        return packName;
    }

    public String getI18NPackName(String packId) {
        Pack pack = this.idToPack.get(packId);
        if (pack == null) {
            return packId;
        }
        String packName = pack.name;
        String key = pack.id;
        if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
            packName = this.langpack.getString(key);
        }
        if ("".equals(packName) || key == null || key.equals(packName)) {
            packName = pack.name;
        }
        return packName;
    }

    protected JLabel createLabel(String msgId, String iconId, GridBagLayout layout, GridBagConstraints constraints) {
        JLabel label = LabelFactory.create(this.parent.langpack.getString(msgId), this.parent.icons.getImageIcon(iconId), 11);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(label, constraints);
        }
        this.add(label);
        return label;
    }

    protected JLabel createPanelWithLabel(String msgId, GridBagLayout layout, GridBagConstraints constraints) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        if (label == null) {
            label = new JLabel("");
        }
        panel.setAlignmentX(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(LabelFactory.create(this.parent.langpack.getString(msgId)));
        panel.add(Box.createHorizontalGlue());
        panel.add(label);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(panel, constraints);
        }
        this.add(panel);
        return label;
    }

    private void refreshPacksToInstall() {
        this.idata.selectedPacks.clear();
        CheckBoxNode cbn = (CheckBoxNode)this.getTree().getModel().getRoot();
        Enumeration<TreeNode> e = cbn.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            CheckBoxNode c = (CheckBoxNode)e.nextElement();
            if (!c.isSelected() && !c.isPartial()) continue;
            this.idata.selectedPacks.add(c.getPack());
        }
    }

    protected JTextArea createTextArea(String msgId, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTextArea area = new JTextArea();
        area.setAlignmentX(0.0f);
        area.setCaretPosition(0);
        area.setEditable(false);
        area.setEditable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString(msgId)));
        area.setFont(this.getControlTextFont());
        if (layout != null && constraints != null) {
            if (scroller != null) {
                layout.addLayoutComponent(scroller, constraints);
            } else {
                layout.addLayoutComponent(area, constraints);
            }
        }
        if (scroller != null) {
            scroller.setViewportView(area);
            this.add(scroller);
        } else {
            this.add(area);
        }
        return area;
    }

    protected JTree createPacksTree(int width, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTree tree;
        this.packsTree = tree = new JTree((CheckBoxNode)this.populateTreePacks(null));
        tree.setCellRenderer(new CheckBoxNodeRenderer(this));
        tree.setEditable(false);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        this.checkTreeController = new CheckTreeController(this);
        tree.addMouseListener(this.checkTreeController);
        tree.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        tree.setBackground(Color.white);
        tree.setToggleClickCount(0);
        scroller.setViewportView(tree);
        scroller.setAlignmentX(0.0f);
        scroller.getViewport().setBackground(Color.white);
        scroller.setPreferredSize(new Dimension(width, this.idata.guiPrefs.height / 3 + 30));
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(scroller, constraints);
        }
        this.add(scroller);
        return tree;
    }

    private void computePacks(List packs) {
        this.names = new HashMap<String, Pack>();
        this.dependenciesExist = false;
        for (Object pack1 : packs) {
            Pack pack = (Pack)pack1;
            this.names.put(pack.name, pack);
            if (pack.dependencies == null && pack.excludeGroup == null) continue;
            this.dependenciesExist = true;
        }
    }

    public void fromModel() {
        TreeModel model = this.packsTree.getModel();
        CheckBoxNode root = (CheckBoxNode)model.getRoot();
        this.updateModel(root);
    }

    private int getRowIndex(Pack pack) {
        Integer o = this.packToRowNumber.get(pack);
        if (o == null) {
            return -1;
        }
        Integer ret = o;
        return ret;
    }

    private void updateModel(CheckBoxNode rnode) {
        Integer state;
        int rowIndex = this.getRowIndex(rnode.getPack());
        if (rowIndex > 0 && (state = (Integer)this.packsModel.getValueAt(rowIndex, 0)) == -2 && rnode.getChildCount() > 0) {
            boolean dirty = false;
            Enumeration<TreeNode> toBeDeselected = rnode.depthFirstEnumeration();
            while (toBeDeselected.hasMoreElements()) {
                CheckBoxNode cbn = (CheckBoxNode)toBeDeselected.nextElement();
                boolean chDirty = cbn.isSelected() || cbn.isPartial() || cbn.isEnabled();
                boolean bl = dirty = dirty || chDirty;
                if (!chDirty) continue;
                cbn.setPartial(false);
                cbn.setSelected(false);
                cbn.setEnabled(false);
                this.setModelValue(cbn);
            }
            if (dirty) {
                this.fromModel();
            }
            return;
        }
        Enumeration<TreeNode> e = rnode.children();
        while (e.hasMoreElements()) {
            int childRowIndex;
            TreeNode next = e.nextElement();
            CheckBoxNode cbnode = (CheckBoxNode)next;
            String nodeText = cbnode.getId();
            Pack nodePack = this.idToPack.get(nodeText);
            if (!cbnode.isPartial() && (childRowIndex = this.getRowIndex(nodePack)) > 0) {
                Integer state2 = (Integer)this.packsModel.getValueAt(childRowIndex, 0);
                cbnode.setEnabled(state2 >= 0);
                cbnode.setSelected(Math.abs(state2) == 1);
            }
            this.updateModel(cbnode);
        }
    }

    public void setModelValue(CheckBoxNode cbnode) {
        Integer modelValue;
        Integer newValue;
        int rowIndex;
        String id = cbnode.getId();
        Pack nodePack = this.idToPack.get(id);
        int value = 0;
        if (cbnode.isEnabled() && cbnode.isSelected()) {
            value = 1;
        }
        if (!cbnode.isEnabled() && cbnode.isSelected()) {
            value = -1;
        }
        if (!cbnode.isEnabled() && !cbnode.isSelected()) {
            value = -2;
        }
        if ((rowIndex = this.getRowIndex(nodePack)) > 0 && !(newValue = Integer.valueOf(value)).equals(modelValue = (Integer)this.packsModel.getValueAt(rowIndex, 0))) {
            this.packsModel.setValueAt(newValue, rowIndex, 0);
        }
    }

    private void createTreeData() {
        this.treeData = new HashMap();
        this.idToPack = new HashMap();
        for (Pack p : this.idata.availablePacks) {
            this.idToPack.put(p.id, p);
            if (p.parent == null) continue;
            ArrayList<String> kids = null;
            kids = this.treeData.containsKey(p.parent) ? this.treeData.get(p.parent) : new ArrayList<String>();
            kids.add(p.id);
            this.treeData.put(p.parent, kids);
        }
    }

    public void setDescription(String id) {
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        if (this.descriptionArea != null) {
            Pack pack = this.idToPack.get(id);
            String desc = "";
            String key = pack.id + ".description";
            if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                desc = this.langpack.getString(key);
            }
            if ("".equals(desc) || key.equals(desc)) {
                desc = pack.description;
            }
            desc = vs.substitute(desc, null);
            this.descriptionArea.setText(desc);
        }
    }

    public void setDependencies(String id) {
        if (this.dependencyArea != null) {
            Pack pack = this.idToPack.get(id);
            List<String> dep = pack.dependencies;
            String list = "";
            if (dep != null) {
                list = list + (this.langpack == null ? "Dependencies: " : this.langpack.getString("PacksPanel.dependencies"));
            }
            for (int j = 0; dep != null && j < dep.size(); ++j) {
                String name = dep.get(j);
                list = list + this.getI18NPackName(this.names.get(name));
                if (j == dep.size() - 1) continue;
                list = list + ", ";
            }
            String excludeslist = this.langpack == null ? "Excludes: " : this.langpack.getString("PacksPanel.excludes");
            int numexcludes = 0;
            int i = this.getRowIndex(pack);
            if (pack.excludeGroup != null) {
                for (int q = 0; q < this.idata.availablePacks.size(); ++q) {
                    Pack otherpack = (Pack)this.idata.availablePacks.get(q);
                    String exgroup = otherpack.excludeGroup;
                    if (exgroup == null || q == i || !pack.excludeGroup.equals(exgroup)) continue;
                    excludeslist = excludeslist + this.getI18NPackName(otherpack) + ", ";
                    ++numexcludes;
                }
            }
            if (dep != null) {
                excludeslist = "    " + excludeslist;
            }
            if (numexcludes > 0) {
                list = list + excludeslist;
            }
            if (list.endsWith(", ")) {
                list = list.substring(0, list.length() - 2);
            }
            this.dependencyArea.setText(list);
        }
    }

    public CheckBoxNode getCbnById(String id) {
        return this.idToCheckBoxNode.get(id);
    }

    private Object populateTreePacks(String parent) {
        if (parent == null) {
            Iterator iter = this.idata.availablePacks.iterator();
            ArrayList<Object> rootNodes = new ArrayList<Object>();
            while (iter.hasNext()) {
                Pack p = (Pack)iter.next();
                if (p.parent != null) continue;
                rootNodes.add(this.populateTreePacks(p.id));
            }
            CheckBoxNode nv = new CheckBoxNode("Root", "Root", rootNodes.toArray(), true);
            return nv;
        }
        ArrayList<Object> links = new ArrayList<Object>();
        ArrayList<String> kidsObject = this.treeData.get(parent);
        Pack p = this.idToPack.get(parent);
        String translated = this.getI18NPackName(parent);
        if (kidsObject != null) {
            ArrayList<String> kids = kidsObject;
            Iterator<String> i$ = kids.iterator();
            while (i$.hasNext()) {
                String kid;
                String kidId = kid = i$.next();
                links.add(this.populateTreePacks(kidId));
            }
            CheckBoxNode cbn = new CheckBoxNode(parent, translated, links.toArray(), true);
            this.idToCheckBoxNode.put(cbn.getId(), cbn);
            cbn.setPack(p);
            cbn.setTotalSize(p.nbytes);
            return cbn;
        }
        CheckBoxNode cbn = new CheckBoxNode(parent, translated, true);
        this.idToCheckBoxNode.put(cbn.getId(), cbn);
        cbn.setPack(p);
        cbn.setTotalSize(p.nbytes);
        return cbn;
    }

    public void panelActivate() {
        try {
            this.packsModel = new PacksModel(this, this.idata, this.parent.getRules()){
                private static final long serialVersionUID = 697462278279845304L;

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            this.packToRowNumber = new HashMap();
            for (Pack p : this.idata.availablePacks) {
                this.packToRowNumber.put(p, this.idata.availablePacks.indexOf(p));
            }
            this.createTreeData();
            this.createNormalLayout();
            this.fromModel();
            CheckBoxNode root = (CheckBoxNode)this.packsTree.getModel().getRoot();
            this.checkTreeController.updateAllParents(root);
            CheckTreeController.initTotalSize(root, false);
            this.packsTree.revalidate();
            this.packsTree.repaint();
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            Iterator iter = this.idata.availablePacks.iterator();
            this.bytes = 0L;
            while (iter.hasNext()) {
                Pack p = (Pack)iter.next();
                if (p.required) {
                    this.bytes += p.nbytes;
                    continue;
                }
                if (!this.idata.selectedPacks.contains(p)) continue;
                this.bytes += p.nbytes;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showSpaceRequired();
        this.showFreeSpace();
    }

    public String getSummaryBody() {
        StringBuffer retval = new StringBuffer(256);
        Iterator iter = this.idata.selectedPacks.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (!first) {
                retval.append("<br>");
            }
            first = false;
            Pack pack = (Pack)iter.next();
            if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                retval.append(this.langpack.getString(pack.id));
                continue;
            }
            retval.append(pack.name);
        }
        return retval.toString();
    }

    public JTree getTree() {
        return this.packsTree;
    }
}

