/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.UserPathInputPanel;
import com.izforge.izpack.panels.UserPathPanelAutomationHelper;
import net.n3.nanoxml.XMLElement;

public class UserPathPanel
extends UserPathInputPanel {
    private static final long serialVersionUID = 3256443616359429170L;
    private static String thisName = "UserPathPanel";
    private boolean skip = false;
    public static String pathVariableName = "UserPathPanelVariable";
    public static String pathPackDependsName = "UserPathPanelDependsName";
    public static String pathElementName = "UserPathPanelElement";

    public UserPathPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, thisName, parent.langpack.getString(thisName + ".variableName"));
        if (this.getDefaultDir() != null) {
            idata.setVariable(pathVariableName, this.getDefaultDir());
        }
    }

    public void panelActivate() {
        boolean found = false;
        System.out.println(thisName + " looking for activation condition");
        String dependsName = this.idata.getVariable(pathPackDependsName);
        if (dependsName != null && !dependsName.equalsIgnoreCase("")) {
            System.out.println("Checking for pack dependency of " + dependsName);
            for (Pack pack : this.idata.selectedPacks) {
                System.out.println("- Checking if " + pack.name + " equals " + dependsName);
                if (!pack.name.equalsIgnoreCase(dependsName)) continue;
                found = true;
                System.out.println("-- Found " + dependsName + ", panel will be shown");
                break;
            }
            this.skip = !found;
        } else {
            System.out.println("Not Checking for a pack dependency, panel will be shown");
            this.skip = false;
        }
        if (this.skip) {
            System.out.println(thisName + " will not be shown");
            this.parent.skipPanel();
            return;
        }
        super.panelActivate();
        this._pathSelectionPanel.setPath(this.idata.getVariable(pathVariableName));
    }

    public boolean isValidated() {
        if (!super.isValidated()) {
            return false;
        }
        this.idata.setVariable(pathVariableName, this._pathSelectionPanel.getPath());
        return true;
    }

    public void makeXMLData(XMLElement panelRoot) {
        if (!this.skip) {
            new UserPathPanelAutomationHelper().makeXMLData(this.idata, panelRoot);
        }
    }

    public String getSummaryBody() {
        if (this.skip) {
            return null;
        }
        return this.idata.getVariable(pathVariableName);
    }
}

