/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordKeystoreValidator
implements Validator {
    @Override
    public boolean validate(ProcessingClient client) {
        boolean returnValue = false;
        String keystorePassword = null;
        String keystoreFile = null;
        String keystoreType = "JKS";
        String skipValidation = null;
        String alias = null;
        String aliasPassword = null;
        Map<String, String> params = this.getParams(client);
        try {
            if (params != null) {
                skipValidation = params.get("skipValidation");
                System.out.println("skipValidation = " + skipValidation);
                if (skipValidation != null && skipValidation.equalsIgnoreCase("true")) {
                    System.out.println("Not validating keystore");
                    return true;
                }
                keystorePassword = params.get("keystorePassword");
                if (keystorePassword == null) {
                    keystorePassword = this.getPassword(client);
                    System.out.println("keystorePassword parameter null, using validator password for keystore");
                } else if (keystorePassword.equalsIgnoreCase("")) {
                    keystorePassword = this.getPassword(client);
                    System.out.println("keystorePassword parameter empty, using validator password for keystore");
                }
                aliasPassword = params.get("aliasPassword");
                if (aliasPassword == null) {
                    aliasPassword = this.getPassword(client);
                    System.out.println("aliasPassword parameter null, using validator password for key");
                } else if (aliasPassword.equalsIgnoreCase("")) {
                    aliasPassword = this.getPassword(client);
                    System.out.println("aliasPassword parameter empty, using validator password for key");
                }
                keystoreType = params.get("keystoreType");
                if (keystoreFile == null) {
                    keystoreType = "JKS";
                    System.out.println("keystoreType parameter null, using default of JKS");
                } else if (keystorePassword.equalsIgnoreCase("")) {
                    keystoreType = "JKS";
                    System.out.println("keystoreType parameter empty, using default of JKS");
                }
                keystoreFile = params.get("keystoreFile");
                if (keystoreFile != null) {
                    System.out.println("Attempting to open keystore: " + keystoreFile);
                    KeyStore ks = PasswordKeystoreValidator.getKeyStore(keystoreFile, keystoreType, keystorePassword.toCharArray());
                    if (ks != null) {
                        returnValue = true;
                        System.out.println("keystore password validated");
                        alias = params.get("keystoreAlias");
                        if (alias != null) {
                            returnValue = ks.containsAlias(alias);
                            if (returnValue) {
                                System.out.println("keystore alias '" + alias + "' found, trying to retrieve");
                                try {
                                    ks.getKey(alias, aliasPassword.toCharArray());
                                    System.out.println("keystore alias '" + alias + "' validated");
                                }
                                catch (Exception e) {
                                    System.out.println("keystore alias validation failed: " + e);
                                    returnValue = false;
                                }
                            } else {
                                System.out.println("keystore alias '" + alias + "' not found");
                            }
                        }
                    }
                } else {
                    System.out.println("keystoreFile param not provided");
                }
            } else {
                System.out.println("params not provided");
            }
        }
        catch (Exception e) {
            System.out.println("validate() Failed: " + e);
        }
        return returnValue;
    }

    private Map<String, String> getParams(ProcessingClient client) {
        HashMap<String, String> returnValue = null;
        PasswordGroup group = null;
        InstallData idata = this.getIdata(client);
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        try {
            group = (PasswordGroup)client;
            if (group.hasParams()) {
                Map<String, String> params = group.getValidatorParams();
                returnValue = new HashMap<String, String>();
                for (String key : params.keySet()) {
                    String value = vs.substitute(params.get(key), null);
                    returnValue.put(key, value);
                }
            }
        }
        catch (Exception e) {
            System.out.println("getParams() Failed: " + e);
        }
        return returnValue;
    }

    private InstallData getIdata(ProcessingClient client) {
        PasswordGroup group = null;
        InstallData idata = null;
        try {
            group = (PasswordGroup)client;
            idata = group.getIdata();
        }
        catch (Exception e) {
            System.out.println("getIdata() Failed: " + e);
        }
        return idata;
    }

    private String getPassword(ProcessingClient client) {
        return client.getFieldContents(0);
    }

    public static KeyStore getKeyStore(String fileName, String type, char[] password) {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(type);
            ks.load(new FileInputStream(fileName), password);
        }
        catch (Exception e) {
            System.out.println("getKeyStore() Failed: " + e);
            ks = null;
        }
        return ks;
    }
}

