/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_ShortcutConstants;
import com.izforge.izpack.util.os.unix.ShellScript;
import com.izforge.izpack.util.os.unix.UnixHelper;
import com.izforge.izpack.util.os.unix.UnixUser;
import com.izforge.izpack.util.os.unix.UnixUsers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unix_Shortcut
extends Shortcut
implements Unix_ShortcutConstants {
    private static String version = "$Id: Unix_Shortcut.java 2163 2008-05-18 13:48:36Z jponge $";
    private static String rev = "$Revision: 2163 $";
    private static String DESKTOP_EXT = ".desktop";
    private static String template = "";
    private static final String N = "\n";
    private static final String H = "#";
    private static final String S = " ";
    private static final String C = "# ";
    private static final String QM = "\"";
    private int ShortcutType;
    private static ShellScript rootScript = null;
    private static ShellScript uninstallScript = null;
    private static ArrayList users = UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops();
    private String createdDirectory;
    private int itsUserType;
    private String itsGroupName;
    private String itsName;
    private String itsFileName;
    private String itsApplnkFolder = "applnk";
    private Properties props;
    private Boolean forAll = Boolean.FALSE;
    public StringBuffer hlp = new StringBuffer();
    private String writtenFileName;

    public Unix_Shortcut() {
        String userLanguage = System.getProperty("user.language", "en");
        this.hlp.append("[Desktop Entry]\n");
        this.hlp.append("Categories=$Categories\n");
        this.hlp.append("Comment=$Comment\n");
        this.hlp.append("Comment[").append(userLanguage).append("]=$Comment\n");
        this.hlp.append("Encoding=$Encoding\n");
        this.hlp.append("Exec=$E_QUOT$Exec$E_QUOT $Arguments\n");
        this.hlp.append("GenericName=$GenericName\n");
        this.hlp.append("GenericName[").append(userLanguage).append("]=$GenericName\n");
        this.hlp.append("Icon=$Icon\n");
        this.hlp.append("MimeType=$MimeType\n");
        this.hlp.append("Name=$Name\n");
        this.hlp.append("Name[").append(userLanguage).append("]=$Name\n");
        this.hlp.append("Path=$P_QUOT$Path$P_QUOT\n");
        this.hlp.append("ServiceTypes=$ServiceTypes\n");
        this.hlp.append("SwallowExec=$SwallowExec\n");
        this.hlp.append("SwallowTitle=$SwallowTitle\n");
        this.hlp.append("Terminal=$Terminal\n");
        this.hlp.append("TerminalOptions=$Options_For_Terminal\n");
        this.hlp.append("Type=$Type\n");
        this.hlp.append("URL=$URL\n");
        this.hlp.append("X-KDE-SubstituteUID=$X_KDE_SubstituteUID\n");
        this.hlp.append("X-KDE-Username=$X_KDE_Username\n");
        this.hlp.append(N);
        this.hlp.append("# created by ").append(this.getClass().getName()).append(S).append(rev).append(N);
        this.hlp.append(C).append(version);
        template = this.hlp.toString();
        this.props = new Properties();
        this.initProps();
        if (rootScript == null) {
            rootScript = new ShellScript();
        }
        if (uninstallScript == null) {
            uninstallScript = new ShellScript();
        }
    }

    private void initProps() {
        String[] propsArray;
        for (String aPropsArray : propsArray = new String[]{"$Comment", "$$LANG_Comment", "$Encoding", "$Exec", "$Arguments", "$GenericName", "$$LANG_GenericName", "$MimeType", "$Name", "$$LANG_Name", "$Path", "$ServiceTypes", "$SwallowExec", "$SwallowTitle", "$Terminal", "$Options_For_Terminal", "$Type", "$X_KDE_SubstituteUID", "$X_KDE_Username", "$Icon", "$URL", "$E_QUOT", "$P_QUOT", "$Categories", "$TryExec"}) {
            this.props.put(aPropsArray, "");
        }
    }

    @Override
    public void initialize(int aType, String aName) throws Exception {
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    @Override
    public boolean supported() {
        return true;
    }

    @Override
    public String getDirectoryCreated() {
        return this.createdDirectory;
    }

    @Override
    public String getFileName() {
        return this.itsFileName;
    }

    @Override
    public Vector<String> getProgramGroups(int userType) {
        Vector<String> groups = new Vector<String>();
        File kdeShareApplnk = this.getKdeShareApplnkFolder(userType);
        try {
            File[] listing;
            for (File aListing : listing = kdeShareApplnk.listFiles()) {
                if (!aListing.isDirectory()) continue;
                groups.add(aListing.getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return groups;
    }

    @Override
    public String getProgramsFolder(int current_user) {
        String result = "";
        result = this.getKdeShareApplnkFolder(current_user).toString();
        return result;
    }

    private File getKdeShareApplnkFolder(int userType) {
        if (userType == 2) {
            return new File(File.separator + "usr" + File.separator + "share" + File.separator + "applications");
        }
        return new File(System.getProperty("user.home") + File.separator + ".local" + File.separator + "share" + File.separator + "applications");
    }

    private String getKdeApplinkFolderName() {
        String applinkFolderName = "applnk";
        if (OsVersion.IS_REDHAT_LINUX) {
            applinkFolderName = "applnk-redhat";
        }
        if (OsVersion.IS_MANDRAKE_LINUX) {
            applinkFolderName = "applnk-mdk";
        }
        return applinkFolderName;
    }

    private File getKdeBase(int userType) {
        File result = null;
        if (userType == 2) {
            FileExecutor fe = new FileExecutor();
            String[] execOut = new String[2];
            int execResult = fe.executeCommand(new String[]{"/usr/bin/env", "kde-config", "--prefix"}, execOut);
            result = new File(execOut[0].trim());
        } else {
            result = new File(System.getProperty("user.home") + File.separator + ".kde");
        }
        return result;
    }

    @Override
    public boolean multipleUsers() {
        return true;
    }

    @Override
    public void save() throws Exception {
        String FS = File.separator;
        String chmod = UnixHelper.getCustomCommand("chmod");
        String chown = UnixHelper.getCustomCommand("chown");
        String rm = UnixHelper.getRmCommand();
        String copy = UnixHelper.getCpCommand();
        String su = UnixHelper.getSuCommand();
        String myHome = System.getProperty("user.home");
        Object target = null;
        String shortCutDef = this.replace();
        boolean rootUser4All = this.getUserType() == 2;
        boolean create4All = this.getCreateForAll();
        if ("".equals(this.itsGroupName) && this.getLinkType() == 3) {
            this.itsFileName = target;
            File writtenDesktopFile = this.writeSafeShortcut(myHome + FS + "Desktop" + FS, this.itsName, shortCutDef);
            this.uninstaller.addFile(writtenDesktopFile.toString(), true);
            if (rootUser4All && create4All) {
                File dest = null;
                File tempFile = File.createTempFile(this.getClass().getName(), Long.toString(System.currentTimeMillis()) + ".tmp");
                Unix_Shortcut.copyTo(writtenDesktopFile, tempFile);
                FileExecutor.getExecOutput(new String[]{chmod, "uga+rwx", tempFile.toString()});
                for (Object user1 : users) {
                    UnixUser user = (UnixUser)user1;
                    if (user.getHome().equals(myHome)) {
                        Debug.log("need not to copy for itself: " + user.getHome() + "==" + myHome);
                        continue;
                    }
                    try {
                        dest = new File(user.getHome() + FS + "Desktop" + FS + writtenDesktopFile.getName());
                        rootScript.append(su);
                        rootScript.append(S);
                        rootScript.append(user.getName());
                        rootScript.append(S);
                        rootScript.append("-c");
                        rootScript.append(S);
                        rootScript.append('\"');
                        rootScript.append(copy);
                        rootScript.append(S);
                        rootScript.append(tempFile.toString());
                        rootScript.append(S);
                        rootScript.append(StringTool.replace(dest.toString(), S, "\\ "));
                        rootScript.appendln('\"');
                        rootScript.append('\n');
                        rootScript.append(chown);
                        rootScript.append(S);
                        rootScript.append(user.getName());
                        rootScript.append(S);
                        rootScript.appendln(StringTool.replace(dest.toString(), S, "\\ "));
                        rootScript.append('\n');
                        rootScript.append('\n');
                        uninstallScript.append(su);
                        uninstallScript.append(S);
                        uninstallScript.append(user.getName());
                        uninstallScript.append(S);
                        uninstallScript.append("-c");
                        uninstallScript.append(S);
                        uninstallScript.append('\"');
                        uninstallScript.append(rm);
                        uninstallScript.append(S);
                        uninstallScript.append(StringTool.replace(dest.toString(), S, "\\ "));
                        uninstallScript.appendln('\"');
                        uninstallScript.appendln();
                    }
                    catch (Exception rex) {
                        System.out.println("Error while su Copy: " + rex.getLocalizedMessage() + "\n\n");
                        rex.printStackTrace();
                    }
                }
                rootScript.append(rm);
                rootScript.append(S);
                rootScript.appendln(tempFile.toString());
                rootScript.appendln();
            }
        } else if (rootUser4All && create4All) {
            File theIcon = new File(this.getIconLocation());
            File commonIcon = new File("/usr/share/pixmaps/" + theIcon.getName());
            try {
                Unix_Shortcut.copyTo(theIcon, commonIcon);
                this.uninstaller.addFile(commonIcon.toString(), true);
            }
            catch (Exception cnc) {
                Debug.log("Could Not Copy: " + theIcon + " to " + commonIcon + "( " + cnc.getMessage() + " )");
            }
            this.itsFileName = target;
            File writtenFile = this.writeSafeShortcut("/usr/share/applications/", this.itsName, shortCutDef);
            this.setWrittenFileName(writtenFile.getName());
            this.uninstaller.addFile(writtenFile.toString(), true);
        } else {
            String localApps = myHome + "/.local/share/applications/";
            String localPixmaps = myHome + "/.local/share/pixmaps/";
            try {
                File f = new File(localApps);
                f.mkdirs();
                f = new File(localPixmaps);
                f.mkdirs();
            }
            catch (Exception ignore) {
                Debug.log("Failed creating " + localApps + " or " + localPixmaps);
            }
            File theIcon = new File(this.getIconLocation());
            File commonIcon = new File(localPixmaps + theIcon.getName());
            try {
                Unix_Shortcut.copyTo(theIcon, commonIcon);
                this.uninstaller.addFile(commonIcon.toString(), true);
            }
            catch (Exception cnc) {
                Debug.log("Could Not Copy: " + theIcon + " to " + commonIcon + "( " + cnc.getMessage() + " )");
            }
            this.itsFileName = target;
            File writtenFile = this.writeSafeShortcut(localApps, this.itsName, shortCutDef);
            this.setWrittenFileName(writtenFile.getName());
            this.uninstaller.addFile(writtenFile.toString(), true);
        }
    }

    @Override
    public void execPostAction() {
        Debug.log("Call of Impl. execPostAction Method in " + this.getClass().getName());
        String pseudoUnique = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        String scriptFilename = null;
        try {
            scriptFilename = File.createTempFile(pseudoUnique, ".sh").toString();
        }
        catch (IOException e) {
            scriptFilename = System.getProperty("java.io.tmpdir", "/tmp") + "/" + pseudoUnique + ".sh";
            e.printStackTrace();
        }
        rootScript.write(scriptFilename);
        rootScript.exec();
        Debug.log(rootScript);
        Debug.log(uninstallScript);
        this.uninstaller.addRootUninstallScript(uninstallScript.getContentAsString());
    }

    public static void copyTo(File inFile, File outFile) throws IOException {
        char[] cbuff = new char[32768];
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        int readedBytes = 0;
        long absWrittenBytes = 0L;
        while ((readedBytes = reader.read(cbuff, 0, cbuff.length)) != -1) {
            writer.write(cbuff, 0, readedBytes);
            absWrittenBytes += (long)readedBytes;
        }
        reader.close();
        writer.close();
    }

    public String getWrittenFileName() {
        return this.writtenFileName;
    }

    protected void setWrittenFileName(String s) {
        this.writtenFileName = s;
    }

    private File writeSafeShortcut(String targetPath, String shortcutName, String shortcutDef) {
        File shortcutFile;
        if (!targetPath.endsWith("/") && !targetPath.endsWith("\\")) {
            targetPath = targetPath + File.separatorChar;
        }
        while ((shortcutFile = new File(targetPath + shortcutName + "-" + System.currentTimeMillis() + DESKTOP_EXT)).exists()) {
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(shortcutFile);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        try {
            fileWriter.write(shortcutDef);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return shortcutFile;
    }

    private File writeShortCut(String target, String shortCutDef) {
        File targetPath = new File(target.substring(0, target.lastIndexOf(File.separatorChar)));
        if (!targetPath.exists()) {
            targetPath.mkdirs();
            this.createdDirectory = targetPath.toString();
        }
        File targetFileName = new File(target);
        File backupFile = new File(targetPath + File.separator + "." + targetFileName.getName() + System.currentTimeMillis());
        if (targetFileName.exists()) {
            try {
                Unix_Shortcut.copyTo(targetFileName, backupFile);
                targetFileName.delete();
            }
            catch (IOException e3) {
                System.out.println("cannot create backup file " + backupFile + " of " + targetFileName);
            }
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(targetFileName);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        try {
            fileWriter.write(shortCutDef);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return targetFileName;
    }

    @Override
    public void setArguments(String args) {
        this.props.put("$Arguments", args);
    }

    @Override
    public void setDescription(String description) {
        this.props.put("$Comment", description);
    }

    @Override
    public void setIconLocation(String path, int index) {
        this.props.put("$Icon", path);
    }

    @Override
    public void setLinkName(String aName) {
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    @Override
    public void setLinkType(int aType) throws IllegalArgumentException, UnsupportedEncodingException {
        this.ShortcutType = aType;
    }

    @Override
    public void setProgramGroup(String aGroupName) {
        this.itsGroupName = aGroupName;
    }

    @Override
    public void setShowCommand(int show) {
    }

    @Override
    public void setTargetPath(String aPath) {
        StringTokenizer whiteSpaceTester = new StringTokenizer(aPath);
        if (whiteSpaceTester.countTokens() > 1) {
            this.props.put("$E_QUOT", QM);
        }
        this.props.put("$Exec", aPath);
    }

    @Override
    public void setUserType(int aUserType) {
        this.itsUserType = aUserType;
    }

    @Override
    public void setWorkingDirectory(String aDirectory) {
        StringTokenizer whiteSpaceTester = new StringTokenizer(aDirectory);
        if (whiteSpaceTester.countTokens() > 1) {
            this.props.put("$P_QUOT", QM);
        }
        this.props.put("$Path", aDirectory);
    }

    public String toString() {
        return this.itsName + N + template;
    }

    public String replace() {
        String result = template;
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result = StringTool.replace(result, key, this.props.getProperty(key));
        }
        return result;
    }

    public static void main(String[] args) {
        Unix_Shortcut aSample = new Unix_Shortcut();
        try {
            aSample.initialize(1, "Start Tomcat");
        }
        catch (Exception exc) {
            System.err.println("Could not init Unix_Shourtcut");
        }
        aSample.replace();
        System.out.println(aSample);
        File targetFileName = new File(System.getProperty("user.home") + File.separator + "Start Tomcat" + DESKTOP_EXT);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(targetFileName);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            fileWriter.write(template);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void setEncoding(String aEncoding) {
        this.props.put("$Encoding", aEncoding);
    }

    @Override
    public void setKdeSubstUID(String trueFalseOrNothing) {
        this.props.put("$X_KDE_SubstituteUID", trueFalseOrNothing);
    }

    @Override
    public void setKdeUserName(String aUserName) {
        this.props.put("$X_KDE_Username", aUserName);
    }

    @Override
    public void setMimetype(String aMimetype) {
        this.props.put("$MimeType", aMimetype);
    }

    @Override
    public void setTerminal(String trueFalseOrNothing) {
        this.props.put("$Terminal", trueFalseOrNothing);
    }

    @Override
    public void setTerminalOptions(String someTerminalOptions) {
        this.props.put("$Options_For_Terminal", someTerminalOptions);
    }

    @Override
    public void setType(String aType) {
        this.props.put("$Type", aType);
    }

    @Override
    public void setURL(String anUrl) {
        this.props.put("$URL", anUrl);
    }

    @Override
    public int getUserType() {
        return this.itsUserType;
    }

    @Override
    public void setCategories(String theCategories) {
        this.props.put("$Categories", theCategories);
    }

    @Override
    public void setTryExec(String aTryExec) {
        this.props.put("$TryExec", aTryExec);
    }

    @Override
    public int getLinkType() {
        return this.ShortcutType;
    }
}

