/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.event.AntAction;
import com.izforge.izpack.event.SimpleUninstallerListener;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AntActionUninstallerListener
extends SimpleUninstallerListener {
    private List<AntAction> antActions = null;

    public void beforeDeletion(List files, AbstractUIProgressHandler handler) throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/antActions");
        if (in == null) {
            return;
        }
        ObjectInputStream objIn = new ObjectInputStream(in);
        List allActions = (List)objIn.readObject();
        objIn.close();
        in.close();
        ArrayList<AntAction> befDel = new ArrayList<AntAction>();
        this.antActions = new ArrayList();
        for (AntAction action : allActions) {
            if (action.getUninstallOrder().equals("beforedeletion")) {
                befDel.add(action);
                continue;
            }
            File tmpFile = IoHelper.copyToTempFile((String)action.getBuildFile(), (String)".xml");
            action.setBuildFile(tmpFile.getCanonicalPath());
            List props = action.getPropertyFiles();
            if (props != null) {
                Iterator iter2 = props.iterator();
                ArrayList<String> newProps = new ArrayList<String>();
                while (iter2.hasNext()) {
                    String propName = (String)iter2.next();
                    File propFile = IoHelper.copyToTempFile((String)propName, (String)".properties");
                    newProps.add(propFile.getCanonicalPath());
                }
                action.setPropertyFiles(newProps);
            }
            this.antActions.add(action);
        }
        if (befDel.size() > 0) {
            for (AntAction act : befDel) {
                act.performUninstallAction();
            }
        }
    }

    public void afterDeletion(List files, AbstractUIProgressHandler handler) throws Exception {
        if (this.antActions != null && this.antActions.size() > 0) {
            for (AntAction act : this.antActions) {
                act.performUninstallAction();
            }
        }
    }
}

