/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.panels.CheckBoxNode;
import com.izforge.izpack.panels.PartialIcon;
import com.izforge.izpack.panels.TreePacksPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private static final JPanel rendererPanel = new JPanel();
    private static final JLabel packSizeLabel = new JLabel();
    private static final JCheckBox checkbox = new JCheckBox();
    private static final JCheckBox normalCheckBox = new JCheckBox();
    private static final Font normalFont = new JCheckBox().getFont();
    private static final Font boldFont = new Font(normalFont.getFontName(), 1, normalFont.getSize());
    private static final Font plainFont = new Font(normalFont.getFontName(), 0, normalFont.getSize());
    private static final Color annotationColor = new Color(0, 0, 120);
    private static final Color changedColor = new Color(200, 0, 0);
    private static Color selectionForeground;
    private static Color selectionBackground;
    private static Color textForeground;
    private static Color textBackground;
    TreePacksPanel treePacksPanel;

    public CheckBoxNodeRenderer(TreePacksPanel t) {
        selectionForeground = UIManager.getColor("Tree.selectionForeground");
        selectionBackground = UIManager.getColor("Tree.selectionBackground");
        textForeground = UIManager.getColor("Tree.textForeground");
        textBackground = UIManager.getColor("Tree.textBackground");
        this.treePacksPanel = t;
        int treeWidth = t.getTree().getPreferredSize().width;
        int height = CheckBoxNodeRenderer.checkbox.getPreferredSize().height;
        int cellWidth = treeWidth - treeWidth / 4;
        rendererPanel.setLayout(new BorderLayout(0, 0));
        rendererPanel.setBackground(textBackground);
        rendererPanel.add("West", checkbox);
        rendererPanel.setAlignmentX(0.0f);
        rendererPanel.setAlignmentY(0.0f);
        rendererPanel.add("East", packSizeLabel);
        rendererPanel.setMinimumSize(new Dimension(cellWidth, height));
        rendererPanel.setPreferredSize(new Dimension(cellWidth, height));
        rendererPanel.setSize(new Dimension(cellWidth, height));
        rendererPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.treePacksPanel.fromModel();
        if (selected) {
            checkbox.setForeground(selectionForeground);
            checkbox.setBackground(selectionBackground);
            rendererPanel.setForeground(selectionForeground);
            rendererPanel.setBackground(selectionBackground);
            packSizeLabel.setBackground(selectionBackground);
        } else {
            checkbox.setForeground(textForeground);
            checkbox.setBackground(textBackground);
            rendererPanel.setForeground(textForeground);
            rendererPanel.setBackground(textBackground);
            packSizeLabel.setBackground(textBackground);
        }
        if (value != null && value instanceof CheckBoxNode) {
            CheckBoxNode node = (CheckBoxNode)value;
            if (node.isTotalSizeChanged()) {
                packSizeLabel.setForeground(changedColor);
            } else if (selected) {
                packSizeLabel.setForeground(selectionForeground);
            } else {
                packSizeLabel.setForeground(annotationColor);
            }
            checkbox.setText(node.getTranslatedText());
            packSizeLabel.setText(Pack.toByteUnitsString((long)node.getTotalSize()));
            if (node.isPartial()) {
                checkbox.setSelected(false);
            } else {
                checkbox.setSelected(node.isSelected());
            }
            checkbox.setEnabled(node.isEnabled());
            packSizeLabel.setEnabled(node.isEnabled());
            if (node.getChildCount() > 0) {
                checkbox.setFont(boldFont);
                packSizeLabel.setFont(boldFont);
            } else {
                checkbox.setFont(normalFont);
                packSizeLabel.setFont(plainFont);
            }
            if (node.isPartial()) {
                checkbox.setIcon((Icon)new PartialIcon());
            } else {
                checkbox.setIcon(normalCheckBox.getIcon());
            }
        }
        return rendererPanel;
    }

    public Component getCheckRenderer() {
        return rendererPanel;
    }
}

