/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.panels.CheckBoxNode;
import com.izforge.izpack.panels.TreePacksPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

/*
 * Exception performing whole class analysis ignored.
 */
class CheckTreeController
extends MouseAdapter {
    JTree tree;
    TreePacksPanel treePacksPanel;
    int checkWidth;

    public CheckTreeController(TreePacksPanel p) {
        this.checkWidth = new JCheckBox().getPreferredSize().width;
        this.tree = p.getTree();
        this.treePacksPanel = p;
    }

    private void selectNode(CheckBoxNode current) {
        current.setPartial(false);
        this.treePacksPanel.setModelValue(current);
        Enumeration e = current.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            CheckBoxNode child = (CheckBoxNode)e.nextElement();
            child.setSelected(current.isSelected() || child.getPack().required);
            if (!child.isSelected()) {
                child.setPartial(false);
            }
            this.treePacksPanel.setModelValue(child);
        }
        this.treePacksPanel.fromModel();
    }

    private boolean hasExcludes(CheckBoxNode node) {
        Enumeration e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            CheckBoxNode cbn = (CheckBoxNode)e.nextElement();
            if (cbn.getPack().excludeGroup == null) continue;
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseEvent me) {
        TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        CheckBoxNode current = (CheckBoxNode)path.getLastPathComponent();
        this.treePacksPanel.setDescription(current.getId());
        this.treePacksPanel.setDependencies(current.getId());
        if (me.getX() > this.tree.getPathBounds((TreePath)path).x + this.checkWidth) {
            return;
        }
        if (current.getPack().required) {
            return;
        }
        boolean currIsSelected = current.isSelected() & !current.isPartial();
        boolean currIsPartial = current.isPartial();
        boolean currHasExcludes = this.hasExcludes(current);
        CheckBoxNode root = (CheckBoxNode)current.getRoot();
        if (currIsPartial && currHasExcludes) {
            current.setSelected(false);
            this.selectNode(current);
            this.updateAllParents(root);
        } else {
            if (!currIsSelected) {
                this.selectAllChildNodes(current);
            }
            current.setSelected(!currIsSelected);
            this.selectNode(current);
            this.updateAllParents(root);
        }
        CheckTreeController.initTotalSize((CheckBoxNode)root, (boolean)true);
        this.treePacksPanel.setBytes((long)((int)root.getTotalSize()));
        this.treePacksPanel.showSpaceRequired();
        this.tree.treeDidChange();
    }

    public void selectAllChildNodes(CheckBoxNode cbn) {
        Enumeration e = cbn.children();
        while (e.hasMoreElements()) {
            CheckBoxNode subCbn = (CheckBoxNode)e.nextElement();
            this.selectAllDependencies(subCbn);
            if (subCbn.getChildCount() > 0) {
                this.selectAllChildNodes(subCbn);
            }
            subCbn.setSelected(true);
            subCbn.setEnabled(true);
            this.treePacksPanel.setModelValue(subCbn);
            subCbn.setEnabled(!subCbn.getPack().required);
        }
    }

    public void selectAllDependencies(CheckBoxNode cbn) {
        Pack pack = cbn.getPack();
        List deps = pack.getDependencies();
        if (deps == null) {
            return;
        }
        for (String depId : deps) {
            CheckBoxNode depCbn = this.treePacksPanel.getCbnById(depId);
            this.selectAllDependencies(depCbn);
            if (depCbn.getChildCount() > 0 && (!depCbn.isSelected() || depCbn.isPartial())) {
                this.selectAllChildNodes(depCbn);
            }
            depCbn.setSelected(true);
            depCbn.setEnabled(true);
            this.treePacksPanel.setModelValue(depCbn);
            depCbn.setEnabled(!depCbn.getPack().required);
        }
    }

    public void updateAllParents(CheckBoxNode root) {
        Enumeration rootEnum = root.depthFirstEnumeration();
        while (rootEnum.hasMoreElements()) {
            CheckBoxNode child = (CheckBoxNode)rootEnum.nextElement();
            if (child.getParent() == null || child.getParent().equals(root)) continue;
            this.updateParents(child);
        }
    }

    private void updateParents(CheckBoxNode node) {
        CheckBoxNode parent = (CheckBoxNode)node.getParent();
        if (parent != null && !parent.equals(parent.getRoot())) {
            Enumeration ne = parent.children();
            boolean allSelected = true;
            boolean allDeselected = true;
            while (ne.hasMoreElements()) {
                CheckBoxNode child = (CheckBoxNode)ne.nextElement();
                if (child.isSelected()) {
                    allDeselected = false;
                } else {
                    allSelected = false;
                }
                if (child.isPartial()) {
                    allDeselected = false;
                    allSelected = false;
                }
                if (allSelected || allDeselected) continue;
                break;
            }
            if (parent.getChildCount() > 0) {
                if (!allSelected && !allDeselected) {
                    CheckTreeController.setPartialParent((CheckBoxNode)parent);
                } else {
                    parent.setPartial(false);
                }
                if (allSelected) {
                    parent.setSelected(true);
                }
                if (allDeselected) {
                    parent.setSelected(false);
                }
                this.treePacksPanel.setModelValue(parent);
                if (allSelected || allDeselected) {
                    this.updateParents(parent);
                }
            }
        }
    }

    public static void setPartialParent(CheckBoxNode node) {
        node.setPartial(true);
        CheckBoxNode parent = (CheckBoxNode)node.getParent();
        if (parent != null && !parent.equals(parent.getRoot())) {
            CheckTreeController.setPartialParent((CheckBoxNode)parent);
        }
    }

    public static long initTotalSize(CheckBoxNode node, boolean markChanged) {
        if (node.isLeaf()) {
            return node.getPack().nbytes;
        }
        Enumeration e = node.children();
        Pack nodePack = node.getPack();
        long bytes = 0L;
        if (nodePack != null) {
            bytes = nodePack.nbytes;
        }
        while (e.hasMoreElements()) {
            CheckBoxNode c = (CheckBoxNode)e.nextElement();
            long size = CheckTreeController.initTotalSize((CheckBoxNode)c, (boolean)markChanged);
            if (!c.isSelected() && !c.isPartial()) continue;
            bytes += size;
        }
        if (markChanged) {
            long old = node.getTotalSize();
            if (old != bytes) {
                node.setTotalSizeChanged(true);
            } else {
                node.setTotalSizeChanged(false);
            }
        }
        node.setTotalSize(bytes);
        return bytes;
    }
}

