/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.coi.tools.os.win.MSWinConstants;
import com.coi.tools.os.win.RegDataContainer;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.HelloPanel;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;

public class CheckedHelloPanel
extends HelloPanel
implements MSWinConstants {
    private static final long serialVersionUID = 1737042770727953387L;
    protected boolean abortInstallation = this.isRegistered();

    public CheckedHelloPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
    }

    protected boolean multipleInstall() throws Exception {
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        int oldVal = rh.getRoot();
        String uninstallName = rh.getUninstallName();
        String oldInstallPath = "<not found>";
        if (uninstallName != null) {
            String keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uninstallName;
            rh.setRoot(-2147483646);
            if (rh.valueExist(keyName, "UninstallString")) {
                String valString = rh.getValue(keyName, "UninstallString").getStringData();
                Object valObj = rh.getValue(keyName, "UninstallString").getDataAsObject();
                if (valObj instanceof String) {
                    valString = (String)valObj;
                }
                RegDataContainer val = rh.getValue(keyName, "UninstallString");
                int typeOfVal = val.getType();
                switch (typeOfVal) {
                    case 1: 
                    case 2: {
                        valString = val.getStringData();
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        throw new Exception("Bad data type of chosen registry value " + keyName);
                    }
                    default: {
                        throw new Exception("Unknown data type of chosen registry value " + keyName);
                    }
                }
                int start = valString.lastIndexOf("-jar") + 5;
                if (start >= 5 && start < valString.length()) {
                    int end;
                    String uPath = valString.substring(start).trim();
                    if (uPath.startsWith("\"")) {
                        uPath = uPath.substring(1).trim();
                    }
                    if ((end = uPath.indexOf("uninstaller")) >= 0) {
                        oldInstallPath = uPath.substring(0, end - 1);
                    }
                }
            }
        }
        rh.setRoot(oldVal);
        String noLuck = this.parent.langpack.getString("CheckedHelloPanel.productAlreadyExist0") + oldInstallPath + this.parent.langpack.getString("CheckedHelloPanel.productAlreadyExist1");
        return this.askQuestion(this.parent.langpack.getString("installer.error"), noLuck, 37) == 47;
    }

    protected boolean isRegistered() {
        boolean retval = false;
        try {
            RegistryHandler rh = RegistryDefaultHandler.getInstance();
            if (rh != null) {
                rh.verify((AutomatedInstallData)this.idata);
                retval = rh.isProductRegistered();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    public boolean isValidated() {
        return !this.abortInstallation;
    }

    public void panelActivate() {
        RegistryHandler rh;
        if (this.abortInstallation) {
            this.parent.lockNextButton();
            try {
                if (this.multipleInstall()) {
                    this.setUniqueUninstallKey();
                    this.abortInstallation = false;
                    this.parent.unlockNextButton();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((rh = RegistryDefaultHandler.getInstance()) != null) {
            this.idata.setVariable("UNINSTALL_NAME", rh.getUninstallName());
        }
    }

    private void setUniqueUninstallKey() throws Exception {
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        int oldVal = rh.getRoot();
        if (oldVal > 100) {
            return;
        }
        String uninstallName = rh.getUninstallName();
        int uninstallModifier = 1;
        while (uninstallName != null) {
            String newUninstallName = uninstallName + "(" + Integer.toString(uninstallModifier) + ")";
            String keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + newUninstallName;
            rh.setRoot(-2147483646);
            if (!rh.keyExist(keyName)) {
                rh.setUninstallName(newUninstallName);
                this.emitNotification(this.parent.langpack.getString("CheckedHelloPanel.infoOverUninstallKey") + newUninstallName);
                break;
            }
            ++uninstallModifier;
        }
    }
}

