/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.CompileHandler;
import com.izforge.izpack.installer.CompileResult;
import com.izforge.izpack.installer.CompileWorker;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.CompilePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.n3.nanoxml.XMLElement;

public class CompilePanel
extends IzPanel
implements ActionListener,
CompileHandler {
    private static final long serialVersionUID = 3258408430669674552L;
    protected JComboBox compilerComboBox;
    protected JComboBox argumentsComboBox;
    protected JButton startButton;
    protected JButton browseButton;
    protected JLabel tipLabel;
    protected JLabel opLabel;
    protected JProgressBar packProgressBar;
    protected JLabel overallLabel;
    protected JProgressBar overallProgressBar;
    private boolean validated = false;
    private CompileWorker worker;
    private int noOfJobs;

    public CompilePanel(InstallerFrame parent, InstallData idata) throws IOException {
        super(parent, idata);
        this.worker = new CompileWorker((AutomatedInstallData)idata, (CompileHandler)this);
        JLabel heading = new JLabel();
        JPanel subpanel = new JPanel();
        JLabel compilerLabel = new JLabel();
        this.compilerComboBox = new JComboBox();
        this.browseButton = ButtonFactory.createButton((String)parent.langpack.getString("CompilePanel.browse"), (Color)idata.buttonsHColor);
        JLabel argumentsLabel = new JLabel();
        this.argumentsComboBox = new JComboBox();
        this.startButton = ButtonFactory.createButton((String)parent.langpack.getString("CompilePanel.start"), (Color)idata.buttonsHColor);
        this.tipLabel = LabelFactory.create((String)parent.langpack.getString("CompilePanel.tip"), (Icon)parent.icons.getImageIcon("tip"), (int)11);
        this.opLabel = new JLabel();
        this.packProgressBar = new JProgressBar();
        this.overallLabel = new JLabel();
        this.overallProgressBar = new JProgressBar();
        this.setLayout((LayoutManager)new GridBagLayout());
        Font font = heading.getFont();
        font = font.deriveFont(1, (float)font.getSize() * 2.0f);
        heading.setFont(font);
        heading.setHorizontalAlignment(0);
        heading.setText(parent.langpack.getString("CompilePanel.heading"));
        heading.setVerticalAlignment(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)heading, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        this.add((Component)subpanel, (Object)gridBagConstraints);
        subpanel.setLayout(new GridBagLayout());
        int row = 0;
        compilerLabel.setHorizontalAlignment(2);
        compilerLabel.setLabelFor(this.compilerComboBox);
        compilerLabel.setText(parent.langpack.getString("CompilePanel.choose_compiler"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row;
        gridBagConstraints.fill = 2;
        subpanel.add((Component)compilerLabel, gridBagConstraints);
        this.compilerComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.fill = 2;
        Iterator it = this.worker.getAvailableCompilers().iterator();
        while (it.hasNext()) {
            this.compilerComboBox.addItem(it.next());
        }
        subpanel.add((Component)this.compilerComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        this.browseButton.addActionListener((ActionListener)this);
        subpanel.add((Component)this.browseButton, gridBagConstraints);
        argumentsLabel.setHorizontalAlignment(2);
        argumentsLabel.setLabelFor(this.argumentsComboBox);
        argumentsLabel.setText(parent.langpack.getString("CompilePanel.additional_arguments"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        subpanel.add((Component)argumentsLabel, gridBagConstraints);
        this.argumentsComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        it = this.worker.getAvailableArguments().iterator();
        while (it.hasNext()) {
            this.argumentsComboBox.addItem(it.next());
        }
        subpanel.add((Component)this.argumentsComboBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        subpanel.add((Component)this.tipLabel, gridBagConstraints);
        this.opLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        subpanel.add((Component)this.opLabel, gridBagConstraints);
        this.packProgressBar.setValue(0);
        this.packProgressBar.setString(parent.langpack.getString("CompilePanel.progress.initial"));
        this.packProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        subpanel.add((Component)this.packProgressBar, gridBagConstraints);
        this.overallLabel.setText(parent.langpack.getString("CompilePanel.progress.overall"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        subpanel.add((Component)this.overallLabel, gridBagConstraints);
        this.overallProgressBar.setValue(0);
        this.overallProgressBar.setString("");
        this.overallProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        subpanel.add((Component)this.overallProgressBar, gridBagConstraints);
        this.startButton.setText(parent.langpack.getString("CompilePanel.start"));
        this.startButton.addActionListener((ActionListener)this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = row++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        subpanel.add((Component)this.startButton, gridBagConstraints);
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startButton) {
            this.worker.setCompiler((String)this.compilerComboBox.getSelectedItem());
            this.worker.setCompilerArguments((String)this.argumentsComboBox.getSelectedItem());
            this.blockGUI();
            this.worker.startThread();
        } else if (e.getSource() == this.browseButton) {
            File file_chosen;
            this.parent.blockGUI();
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File((String)this.compilerComboBox.getSelectedItem()).getParentFile());
            int result = chooser.showDialog((Component)this.parent, this.parent.langpack.getString("CompilePanel.browse.approve"));
            if (result == 0 && (file_chosen = chooser.getSelectedFile()).isFile()) {
                this.compilerComboBox.setSelectedItem(file_chosen.getAbsolutePath());
            }
            this.parent.releaseGUI();
        }
    }

    protected void blockGUI() {
        this.startButton.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.compilerComboBox.setEnabled(false);
        this.argumentsComboBox.setEnabled(false);
        this.parent.blockGUI();
    }

    protected void releaseGUI(boolean allowconfig) {
        if (allowconfig) {
            this.startButton.setEnabled(true);
            this.browseButton.setEnabled(true);
            this.compilerComboBox.setEnabled(true);
            this.argumentsComboBox.setEnabled(true);
        }
        this.parent.releaseGUI();
    }

    public void handleCompileError(CompileResult error) {
        String message = error.getMessage();
        this.opLabel.setText(message);
        CompilerErrorDialog dialog = new CompilerErrorDialog(this, (Frame)this.parent, message, this.idata.buttonsHColor);
        dialog.show(error);
        if (dialog.getResult() == 23) {
            error.setAction(39);
        } else if (dialog.getResult() == 47) {
            error.setAction(31);
        } else {
            error.setAction(27);
        }
    }

    public void startAction(String name, int noOfJobs1) {
        this.noOfJobs = noOfJobs1;
        this.overallProgressBar.setMaximum(noOfJobs1);
        this.parent.lockPrevButton();
    }

    public void stopAction() {
        CompileResult result = this.worker.getResult();
        this.releaseGUI(result.isReconfigure());
        if (result.isContinue()) {
            this.parent.lockPrevButton();
            this.packProgressBar.setString(this.parent.langpack.getString("CompilePanel.progress.finished"));
            this.packProgressBar.setEnabled(false);
            this.packProgressBar.setValue(this.packProgressBar.getMaximum());
            this.overallProgressBar.setValue(this.noOfJobs);
            String no_of_jobs = Integer.toString(this.noOfJobs);
            this.overallProgressBar.setString(no_of_jobs + " / " + no_of_jobs);
            this.overallProgressBar.setEnabled(false);
            this.opLabel.setText(" ");
            this.opLabel.setEnabled(false);
            this.validated = true;
            this.idata.installSuccess = true;
            if (this.idata.panels.indexOf(this) != this.idata.panels.size() - 1) {
                this.parent.unlockNextButton();
            }
        } else {
            this.idata.installSuccess = false;
        }
    }

    public void progress(int val, String msg) {
        this.packProgressBar.setValue(val + 1);
        this.opLabel.setText(msg);
    }

    public void nextStep(String jobName, int max, int jobNo) {
        this.packProgressBar.setValue(0);
        this.packProgressBar.setMaximum(max);
        this.packProgressBar.setString(jobName);
        this.opLabel.setText("");
        this.overallProgressBar.setValue(jobNo);
        this.overallProgressBar.setString(Integer.toString(jobNo) + " / " + Integer.toString(this.noOfJobs));
    }

    public void setSubStepNo(int max) {
        this.packProgressBar.setMaximum(max);
    }

    public void panelActivate() {
        Iterator it = this.worker.getAvailableCompilers().iterator();
        this.compilerComboBox.removeAllItems();
        while (it.hasNext()) {
            this.compilerComboBox.addItem(it.next());
        }
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
    }

    public void makeXMLData(XMLElement panelRoot) {
        XMLElement compiler = new XMLElement("compiler");
        compiler.setContent(this.worker.getCompiler());
        panelRoot.addChild(compiler);
        XMLElement args = new XMLElement("arguments");
        args.setContent(this.worker.getCompilerArguments());
        panelRoot.addChild(args);
    }

    static /* synthetic */ InstallerFrame access$000(CompilePanel x0) {
        return x0.parent;
    }

    static /* synthetic */ InstallerFrame access$100(CompilePanel x0) {
        return x0.parent;
    }

    static /* synthetic */ InstallerFrame access$200(CompilePanel x0) {
        return x0.parent;
    }

    static /* synthetic */ InstallerFrame access$300(CompilePanel x0) {
        return x0.parent;
    }
}

