/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.CompileHandler;
import com.izforge.izpack.installer.CompileResult;
import com.izforge.izpack.installer.CompileWorker;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.PanelAutomationHelper;
import java.io.IOException;
import java.io.PrintStream;
import net.n3.nanoxml.XMLElement;

public class CompilePanelAutomationHelper
extends PanelAutomationHelper
implements PanelAutomation,
CompileHandler {
    private CompileWorker worker = null;
    private int job_max = 0;
    private String job_name = null;
    private int last_line_len = 0;
    private PrintStream stdout;
    private PrintStream stderr;

    public void makeXMLData(AutomatedInstallData installData, XMLElement panelRoot) {
    }

    public boolean runAutomated(AutomatedInstallData idata, XMLElement panelRoot) {
        XMLElement compiler_xml = panelRoot.getFirstChildNamed("compiler");
        String compiler = null;
        if (compiler_xml != null) {
            compiler = compiler_xml.getContent();
        }
        if (compiler == null) {
            System.out.println("invalid automation data: could not find compiler");
            return false;
        }
        XMLElement args_xml = panelRoot.getFirstChildNamed("arguments");
        String args = null;
        if (args_xml != null) {
            args = args_xml.getContent();
        }
        if (args_xml == null) {
            System.out.println("invalid automation data: could not find compiler arguments");
            return false;
        }
        try {
            this.worker = new CompileWorker(idata, (CompileHandler)this);
            this.worker.setCompiler(compiler);
            this.worker.setCompilerArguments(args);
            this.stdout = System.out;
            this.stderr = System.err;
            this.worker.run();
            return this.worker.getResult().isSuccess();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void startAction(String name, int noOfJobs) {
        this.stdout.println("[ Starting compilation ]");
        this.job_name = "";
    }

    public void handleCompileError(CompileResult error) {
        this.stdout.println();
        this.stdout.println("[ Compilation failed ]");
        this.stderr.println("Command line: " + error.getCmdline());
        this.stderr.println();
        this.stderr.println("stdout of compiler:");
        this.stderr.println(error.getStdout());
        this.stderr.println("stderr of compiler:");
        this.stderr.println(error.getStderr());
        error.setAction(27);
    }

    public void stopAction() {
        if (this.job_name != null && this.last_line_len > 0) {
            String line = this.job_name + ": done.";
            this.stdout.print("\r" + line);
            for (int i = line.length(); i < this.last_line_len; ++i) {
                this.stdout.print(' ');
            }
            this.stdout.println();
        }
        if (this.worker.getResult().isSuccess()) {
            this.stdout.println("[ Compilation successful ]");
        }
    }

    public void progress(int val, String msg) {
        double percentage = (double)val * 100.0 / (double)this.job_max;
        String percent = new Integer((int)percentage).toString() + '%';
        String line = this.job_name + ": " + percent;
        int line_len = line.length();
        this.stdout.print("\r" + line);
        for (int i = line_len; i < this.last_line_len; ++i) {
            this.stdout.print(' ');
        }
        this.last_line_len = line_len;
    }

    public void nextStep(String jobName, int max, int jobNo) {
        if (this.job_name != null && this.last_line_len > 0) {
            String line = this.job_name + ": done.";
            this.stdout.print("\r" + line);
            for (int i = line.length(); i < this.last_line_len; ++i) {
                this.stdout.print(' ');
            }
            this.stdout.println();
        }
        this.job_max = max;
        this.job_name = jobName;
        this.last_line_len = 0;
    }

    public void setSubStepNo(int no_of_substeps) {
        this.job_max = no_of_substeps;
    }
}

