/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCheckPanel
extends IzPanel {
    private static final long serialVersionUID = 3257848774955905587L;
    static int instanceCount = 0;
    protected int instanceNumber = 0;
    private InstallData iData;
    JEditorPane staticText;

    public DataCheckPanel(InstallerFrame parent, InstallData id) {
        super(parent, id);
        this.iData = id;
        this.instanceNumber = instanceCount++;
        String sInfo = "Debugging data.  All InstallData variables and all packs (selected packs are marked).";
        BoxLayout bLayout = new BoxLayout((Container)this, 1);
        this.setLayout((LayoutManager)bLayout);
        JLabel lInfo = new JLabel(sInfo);
        this.add((Component)lInfo);
        this.staticText = new JEditorPane();
        this.staticText.setEditable(false);
        JScrollPane scrollText = new JScrollPane(this.staticText);
        this.add((Component)new JLabel("  "));
        this.add((Component)scrollText);
    }

    public void panelActivate() {
        this.printDebugInfo();
    }

    private String getPackNames(List<Pack> packList) {
        String sOutput = "";
        for (int i = 0; i < packList.size(); ++i) {
            Pack iPack = packList.get(i);
            String pStatus = this.iData.selectedPacks.indexOf(iPack) != -1 ? "Selected" : "Unselected";
            sOutput = sOutput + "\t" + i + ": " + iPack.name + " (" + pStatus + ")\n";
        }
        return sOutput;
    }

    private void printDebugInfo() {
        int i = 0;
        String sInfo = "InstallData Variables:\n";
        System.out.println("------------------------Data Check Panel Instance " + this.instanceNumber + "------------------------");
        System.out.println("InstallData Variables:");
        Properties varList = this.iData.getVariables();
        Object[] alphaName = new String[varList.size()];
        Enumeration<?> varNames = varList.propertyNames();
        while (varNames.hasMoreElements()) {
            alphaName[i++] = (String)varNames.nextElement();
        }
        Arrays.sort(alphaName);
        for (i = 0; i < alphaName.length; ++i) {
            sInfo = sInfo + "\tName: " + (String)alphaName[i] + ", Value: " + varList.getProperty((String)alphaName[i]) + "\n";
        }
        sInfo = sInfo + "\nAvailable Packs: \n" + this.getPackNames(this.iData.allPacks) + "\n";
        System.out.println(sInfo);
        this.staticText.setText(sInfo);
    }

    public boolean isValidated() {
        return true;
    }
}

