/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.AutomatedInstallScriptFilter;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FinishPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257282535107998009L;
    protected JButton autoButton;
    protected VariableSubstitutor vs;

    public FinishPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, (LayoutManager2)new IzPanelLayout());
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.parent.langpack.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        if (this.idata.installSuccess) {
            this.add((Component)LabelFactory.create((String)this.parent.langpack.getString("FinishPanel.success"), (Icon)this.parent.icons.getImageIcon("preferences"), (int)10), (Object)"nextLine");
            this.add(IzPanelLayout.createVerticalStrut((int)5));
            if (this.idata.uninstallOutJar != null) {
                String path = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
                this.add((Component)LabelFactory.create((String)this.parent.langpack.getString("FinishPanel.uninst.info"), (Icon)this.parent.icons.getImageIcon("preferences"), (int)10), (Object)"nextLine");
                this.add((Component)LabelFactory.create((String)path, (Icon)this.parent.icons.getImageIcon("empty"), (int)10), (Object)"nextLine");
            }
            this.add(IzPanelLayout.createVerticalStrut((int)5));
            this.autoButton = ButtonFactory.createButton((String)this.parent.langpack.getString("FinishPanel.auto"), (Icon)this.parent.icons.getImageIcon("edit"), (Color)this.idata.buttonsHColor);
            this.autoButton.setToolTipText(this.parent.langpack.getString("FinishPanel.auto.tip"));
            this.autoButton.addActionListener((ActionListener)this);
            this.add((Component)this.autoButton, (Object)"nextLine");
        } else {
            this.add((Component)LabelFactory.create((String)this.parent.langpack.getString("FinishPanel.fail"), (Icon)this.parent.icons.getImageIcon("stop"), (int)10), (Object)"nextLine");
        }
        this.getLayoutHelper().completeLayout();
        Log.getInstance().informUser();
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(this.idata.getInstallPath()));
        fc.setMultiSelectionEnabled(false);
        fc.addChoosableFileFilter((FileFilter)new AutomatedInstallScriptFilter());
        try {
            if (fc.showSaveDialog((Component)this) == 0) {
                File file = fc.getSelectedFile();
                FileOutputStream out = new FileOutputStream(file);
                BufferedOutputStream outBuff = new BufferedOutputStream(out, 5120);
                this.parent.writeXMLTree(this.idata.xmlData, (OutputStream)outBuff);
                outBuff.flush();
                outBuff.close();
                this.autoButton.setEnabled(false);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog((Component)this, err.toString(), this.parent.langpack.getString("installer.error"), 0);
        }
    }

    protected String translatePath(String destination) {
        destination = this.vs.substitute(destination, null);
        return destination.replace('/', File.separatorChar);
    }
}

