/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.PacksPanelBase;
import com.izforge.izpack.util.IoHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class ImgPacksPanel
extends PacksPanelBase {
    private static final long serialVersionUID = 3977858492633659444L;
    private HashMap<String, ImageIcon> images;
    private JLabel imgLabel;

    public ImgPacksPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
    }

    protected void createNormalLayout() {
        this.preLoadImages();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.setLayout((LayoutManager)layout);
        this.parent.buildConstraints(gbConstraints, 0, 0, 1, 1, 0.25, 0.0);
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        gbConstraints.anchor = 17;
        this.createLabel("PacksPanel.info", "preferences", layout, gbConstraints);
        this.parent.buildConstraints(gbConstraints, 1, 0, 1, 1, 0.5, 0.0);
        this.createLabel("ImgPacksPanel.snap", "tip", layout, gbConstraints);
        this.tableScroller = new JScrollPane();
        this.parent.buildConstraints(gbConstraints, 0, 1, 1, 2, 0.5, 0.0);
        gbConstraints.fill = 1;
        this.packsTable = this.createPacksTable(250, this.tableScroller, layout, gbConstraints);
        Iterator pack_it = this.idata.availablePacks.iterator();
        Pack firstImgPack = null;
        boolean imgFound = false;
        while (!imgFound && pack_it.hasNext()) {
            firstImgPack = (Pack)pack_it.next();
            imgFound = firstImgPack.packImgId != null;
        }
        this.imgLabel = imgFound ? new JLabel((Icon)this.images.get(firstImgPack.packImgId)) : new JLabel();
        JScrollPane imgScroller = new JScrollPane(this.imgLabel);
        imgScroller.setPreferredSize(this.getPreferredSizeFromImages());
        this.parent.buildConstraints(gbConstraints, 1, 1, 1, 1, 0.5, 1.0);
        layout.addLayoutComponent(imgScroller, gbConstraints);
        this.add((Component)imgScroller);
        Component strut = Box.createVerticalStrut(20);
        this.parent.buildConstraints(gbConstraints, 1, 2, 1, 3, 0.0, 0.0);
        layout.addLayoutComponent(strut, gbConstraints);
        this.add(strut);
        if (this.dependenciesExist) {
            JScrollPane depScroller = new JScrollPane();
            depScroller.setPreferredSize(new Dimension(250, 40));
            this.parent.buildConstraints(gbConstraints, 0, 3, 1, 1, 0.5, 0.5);
            this.dependencyArea = this.createTextArea("ImgPacksPanel.dependencyList", depScroller, layout, gbConstraints);
        }
        JScrollPane descriptionScroller = new JScrollPane();
        descriptionScroller.setPreferredSize(new Dimension(200, 60));
        descriptionScroller.setBorder(BorderFactory.createEmptyBorder());
        this.parent.buildConstraints(gbConstraints, 1, 3, 1, 1, 0.5, 0.5);
        this.descriptionArea = this.createTextArea("PacksPanel.description", descriptionScroller, layout, gbConstraints);
        this.parent.buildConstraints(gbConstraints, 0, 4, 2, 1, 0.0, 0.0);
        this.createLabel("PacksPanel.tip", "tip", layout, gbConstraints);
        this.parent.buildConstraints(gbConstraints, 0, 5, 2, 1, 0.0, 0.0);
        this.spaceLabel = this.createPanelWithLabel("PacksPanel.space", layout, gbConstraints);
        if (IoHelper.supported((String)"getFreeSpace")) {
            this.parent.buildConstraints(gbConstraints, 0, 6, 2, 1, 0.0, 0.0);
            this.freeSpaceLabel = this.createPanelWithLabel("PacksPanel.freespace", layout, gbConstraints);
        }
    }

    private void preLoadImages() {
        int size = this.idata.availablePacks.size();
        this.images = new HashMap(size);
        for (Pack pack : this.idata.availablePacks) {
            if (pack.packImgId == null) continue;
            try {
                URL url = ResourceManager.getInstance().getURL(pack.packImgId);
                ImageIcon img = new ImageIcon(url);
                this.images.put(pack.packImgId, img);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    private Dimension getPreferredSizeFromImages() {
        int maxWidth = 80;
        int maxHeight = 60;
        Iterator i$ = this.images.values().iterator();
        while (i$.hasNext()) {
            ImageIcon imageIcon;
            ImageIcon icon = imageIcon = (ImageIcon)i$.next();
            maxWidth = Math.max(maxWidth, icon.getIconWidth());
            maxHeight = Math.max(maxHeight, icon.getIconHeight());
        }
        maxWidth = Math.min(maxWidth + 20, this.idata.guiPrefs.width - 150);
        maxHeight = Math.min(maxHeight + 20, this.idata.guiPrefs.height - 150);
        return new Dimension(maxWidth, maxHeight);
    }

    public void valueChanged(ListSelectionEvent e) {
        int i = this.packsTable.getSelectedRow();
        super.valueChanged(e);
        if (i < 0) {
            return;
        }
        if (i >= 0) {
            Pack pack = (Pack)this.idata.availablePacks.get(i);
            this.imgLabel.setIcon((Icon)this.images.get(pack.packImgId));
        }
    }
}

