/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.coi.tools.os.win.NativeLibException;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.PathInputPanel;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class JDKPathPanel
extends PathInputPanel {
    private static final long serialVersionUID = 3257006553327810104L;
    private static final String[] testFiles = new String[]{"lib" + File.separator + "tools.jar"};
    private static final String JDK_ROOT_KEY = "Software\\JavaSoft\\Java Development Kit";
    private static final String JDK_VALUE_NAME = "JavaHome";
    private static final String OSX_JDK_HOME = "/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Home/";
    private static final int OK = 0;
    private static final int BAD_VERSION = 1;
    private static final int BAD_REAL_PATH = 2;
    private static final int BAD_REG_PATH = 3;
    private String detectedVersion;
    private String minVersion = null;
    private String maxVersion = null;
    private String variableName;
    private Set<String> badRegEntries = null;

    public JDKPathPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        this.setMustExist(true);
        if (!OsVersion.IS_OSX) {
            this.setExistFiles(testFiles);
        }
        this.setMinVersion(idata.getVariable("JDKPathPanel.minVersion"));
        this.setMaxVersion(idata.getVariable("JDKPathPanel.maxVersion"));
        this.setVariableName("JDKPath");
    }

    public boolean isValidated() {
        boolean retval = false;
        if (super.isValidated()) {
            switch (this.verifyVersionEx()) {
                case 0: {
                    this.idata.setVariable(this.getVariableName(), this.pathSelectionPanel.getPath());
                    retval = true;
                    break;
                }
                case 3: {
                    if (this.askQuestion(this.parent.langpack.getString("installer.warning"), this.parent.langpack.getString("JDKPathPanel.nonValidPathInReg"), 37, 49) != 47) break;
                    this.idata.setVariable(this.getVariableName(), this.pathSelectionPanel.getPath());
                    retval = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    String min = this.getMinVersion();
                    String max = this.getMaxVersion();
                    StringBuffer message = new StringBuffer();
                    message.append(this.parent.langpack.getString("JDKPathPanel.badVersion1")).append(this.getDetectedVersion()).append(this.parent.langpack.getString("JDKPathPanel.badVersion2"));
                    if (min != null && max != null) {
                        message.append(min).append(" - ").append(max);
                    } else if (min != null) {
                        message.append(" >= ").append(min);
                    } else if (max != null) {
                        message.append(" <= ").append(max);
                    }
                    message.append(this.parent.langpack.getString("JDKPathPanel.badVersion3"));
                    if (this.askQuestion(this.parent.langpack.getString("installer.warning"), message.toString(), 37, 49) != 47) break;
                    this.idata.setVariable(this.getVariableName(), this.pathSelectionPanel.getPath());
                    retval = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: unknown result of version verification.");
                }
            }
        }
        return retval;
    }

    public void panelActivate() {
        super.panelActivate();
        String chosenPath = this.idata.getVariable(this.getVariableName()) != null ? this.idata.getVariable(this.getVariableName()) : (OsVersion.IS_OSX ? OSX_JDK_HOME : new File(this.idata.getVariable("JAVA_HOME")).getParent());
        this.pathSelectionPanel.setPath(chosenPath);
        if (!this.pathIsValid() || !this.verifyVersion()) {
            chosenPath = this.resolveInRegistry();
            if (!this.pathIsValid() || !this.verifyVersion()) {
                chosenPath = "";
            }
        }
        this.pathSelectionPanel.setPath(chosenPath);
        String var = this.idata.getVariable("JDKPathPanel.skipIfValid");
        if (chosenPath.length() > 0 && var != null && "yes".equalsIgnoreCase(var)) {
            this.idata.setVariable(this.getVariableName(), chosenPath);
            this.parent.skipPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveInRegistry() {
        String retval = "";
        int oldVal = 0;
        RegistryHandler rh = null;
        this.badRegEntries = new HashSet();
        try {
            rh = RegistryDefaultHandler.getInstance();
            if (rh == null) {
                String string = retval;
                return string;
            }
            rh.verify((AutomatedInstallData)this.idata);
            oldVal = rh.getRoot();
            rh.setRoot(-2147483646);
            Object[] keys = rh.getSubkeys(JDK_ROOT_KEY);
            if (keys == null || keys.length == 0) {
                String e = retval;
                return e;
            }
            Arrays.sort(keys);
            String min = this.getMinVersion();
            String max = this.getMaxVersion();
            for (int i = keys.length - 1; i > 0; --i) {
                if (!this.compareVersions((String)keys[i], max, false, 4, 4, "__NO_NOT_IDENTIFIER_") || !this.compareVersions((String)keys[i], min, true, 4, 4, "__NO_NOT_IDENTIFIER_")) continue;
                String cv = "Software\\JavaSoft\\Java Development Kit\\" + (String)keys[i];
                String path = rh.getValue(cv, JDK_VALUE_NAME).getStringData();
                this.pathSelectionPanel.setPath(path);
                if (!this.pathIsValid()) {
                    this.badRegEntries.add(keys[i]);
                } else if ("".equals(retval)) {
                    retval = path;
                }
                this.pathSelectionPanel.setPath(retval);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rh != null && oldVal != 0) {
                try {
                    rh.setRoot(-2147483646);
                }
                catch (NativeLibException e) {
                    e.printStackTrace();
                }
            }
        }
        return retval;
    }

    private int verifyVersionEx() {
        String vs;
        String min = this.getMinVersion();
        String max = this.getMaxVersion();
        int retval = 0;
        if (min == null && max == null) {
            return 0;
        }
        if (!this.pathIsValid()) {
            return 2;
        }
        String[] params = new String[]{this.pathSelectionPanel.getPath() + File.separator + "bin" + File.separator + "java", "-version"};
        String[] output = new String[2];
        FileExecutor fe = new FileExecutor();
        fe.executeCommand(params, output);
        String string = vs = output[0].length() > 0 ? output[0] : output[1];
        if (min != null && !this.compareVersions(vs, min, true, 4, 4, "__NO_NOT_IDENTIFIER_")) {
            retval = 1;
        }
        if (max != null && !this.compareVersions(vs, max, false, 4, 4, "__NO_NOT_IDENTIFIER_")) {
            retval = 1;
        }
        if (retval == 0 && this.badRegEntries != null && this.badRegEntries.size() > 0 && this.badRegEntries.contains(this.getDetectedVersion())) {
            retval = 3;
        }
        return retval;
    }

    private boolean verifyVersion() {
        return this.verifyVersionEx() <= 0;
    }

    private boolean compareVersions(String in, String template, boolean isMin, int assumedPlace, int halfRange, String useNotIdentifier) {
        int i;
        StringTokenizer st = new StringTokenizer(in, " \t\n\r\f\"");
        int currentRange = 0;
        String[] interestedEntries = new String[halfRange + halfRange];
        for (i = 0; i < assumedPlace - halfRange; ++i) {
            if (!st.hasMoreTokens()) continue;
            st.nextToken();
        }
        for (i = 0; i < halfRange + halfRange; ++i) {
            if (!st.hasMoreTokens()) continue;
            interestedEntries[i] = st.nextToken();
            ++currentRange;
        }
        for (i = 0; i < currentRange && (useNotIdentifier != null && interestedEntries[i].indexOf(useNotIdentifier) > -1 || Character.getType(interestedEntries[i].charAt(0)) != 9); ++i) {
        }
        if (i == currentRange) {
            this.detectedVersion = "<not found>";
            return false;
        }
        this.detectedVersion = interestedEntries[i];
        StringTokenizer current = new StringTokenizer(interestedEntries[i], "._-");
        StringTokenizer needed = new StringTokenizer(template, "._-");
        while (needed.hasMoreTokens()) {
            if (!current.hasMoreTokens()) {
                return false;
            }
            String cur = current.nextToken();
            String nee = needed.nextToken();
            int curVal = 0;
            int neededVal = 0;
            try {
                curVal = Integer.parseInt(cur);
                neededVal = Integer.parseInt(nee);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            if (curVal < neededVal) {
                return !isMin;
            }
            if (Integer.parseInt(cur) <= Integer.parseInt(nee)) continue;
            return isMin;
        }
        return true;
    }

    public String getDetectedVersion() {
        return this.detectedVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    protected void setDetectedVersion(String string) {
        this.detectedVersion = string;
    }

    protected void setMaxVersion(String string) {
        this.maxVersion = string != null && string.length() > 0 ? string : "99.0.0";
    }

    protected void setMinVersion(String string) {
        this.minVersion = string != null && string.length() > 0 ? string : "1.0.0";
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getSummaryBody() {
        return this.idata.getVariable(this.getVariableName());
    }
}

