/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

class PacksModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3258128076746733110L;
    private static final String INITAL_PACKSELECTION = "initial.pack.selection";
    private List packs;
    private List packsToInstall;
    private Map installedpacks;
    private boolean modifyinstallation;
    private PacksPanelInterface panel;
    private LocaleDatabase langpack;
    private int[] checkValues;
    Map<String, Pack> namesObj;
    Map<String, Integer> namesPos;
    private RulesEngine rules;
    private Properties variables;

    public PacksModel(PacksPanelInterface panel, InstallData idata, RulesEngine rules) {
        this.modifyinstallation = Boolean.valueOf(idata.getVariable("modify.izpack.install"));
        this.installedpacks = new HashMap();
        if (this.modifyinstallation) {
            try {
                FileInputStream fin = new FileInputStream(new File(idata.getInstallPath() + File.separator + ".installationinformation"));
                ObjectInputStream oin = new ObjectInputStream(fin);
                List packsinstalled = (List)oin.readObject();
                for (Object aPacksinstalled : packsinstalled) {
                    Pack installedpack = (Pack)aPacksinstalled;
                    if (installedpack.id != null && installedpack.id.length() > 0) {
                        this.installedpacks.put(installedpack.id, installedpack);
                        continue;
                    }
                    this.installedpacks.put(installedpack.name, installedpack);
                }
                this.removeAlreadyInstalledPacks(idata.selectedPacks);
                Debug.trace((Object)("Found " + packsinstalled.size() + " installed packs"));
                Properties variables = (Properties)oin.readObject();
                for (Object key : variables.keySet()) {
                    idata.setVariable((String)key, (String)variables.get(key));
                }
                fin.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.rules = rules;
        this.packs = idata.availablePacks;
        this.packsToInstall = idata.selectedPacks;
        this.panel = panel;
        this.variables = idata.getVariables();
        this.variables.setProperty(INITAL_PACKSELECTION, Boolean.toString(true));
        this.langpack = panel.getLangpack();
        this.checkValues = new int[this.packs.size()];
        this.reverseDeps();
        this.initvalues();
        this.updateConditions(true);
        this.refreshPacksToInstall();
        this.variables.setProperty(INITAL_PACKSELECTION, Boolean.toString(false));
    }

    private void removeAlreadyInstalledPacks(List selectedpacks) {
        ArrayList<Pack> removepacks = new ArrayList<Pack>();
        for (Object selectedpack1 : selectedpacks) {
            Pack selectedpack = (Pack)selectedpack1;
            String key = "";
            key = selectedpack.id != null && selectedpack.id.length() > 0 ? selectedpack.id : selectedpack.name;
            if (!this.installedpacks.containsKey(key)) continue;
            removepacks.add(selectedpack);
        }
        for (Pack removepack : removepacks) {
            selectedpacks.remove(removepack);
        }
    }

    public void updateConditions() {
        this.updateConditions(false);
    }

    private void updateConditions(boolean initial) {
        boolean changes = true;
        while (changes) {
            changes = false;
            for (Object pack1 : this.packs) {
                Pack pack = (Pack)pack1;
                int pos = this.getPos(pack.name);
                Debug.trace((Object)("Conditions fulfilled for: " + pack.name + "?"));
                if (this.rules.canInstallPack(pack.id, this.variables)) continue;
                Debug.trace((Object)"no");
                if (this.rules.canInstallPackOptional(pack.id, this.variables)) {
                    Debug.trace((Object)"optional");
                    Debug.trace((Object)(pack.id + " can be installed optionally."));
                    if (!initial || this.checkValues[pos] == 0) continue;
                    this.checkValues[pos] = 0;
                    changes = true;
                    break;
                }
                Debug.trace((Object)(pack.id + " can not be installed."));
                if (this.checkValues[pos] == -2) continue;
                this.checkValues[pos] = -2;
                changes = true;
                break;
            }
            this.refreshPacksToInstall();
        }
    }

    private void reverseDeps() {
        Pack pack;
        this.namesObj = new HashMap();
        for (Object pack2 : this.packs) {
            pack = (Pack)pack2;
            this.namesObj.put(pack.name, pack);
        }
        for (Object pack1 : this.packs) {
            pack = (Pack)pack1;
            List deps = pack.dependencies;
            for (int j = 0; deps != null && j < deps.size(); ++j) {
                String name = (String)deps.get(j);
                Pack parent = (Pack)this.namesObj.get(name);
                parent.addRevDep(pack.name);
            }
        }
    }

    private void initvalues() {
        Pack pack;
        int i;
        this.namesPos = new HashMap();
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            this.namesPos.put(pack.name, i);
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            if (!this.packsToInstall.contains(pack)) continue;
            this.checkValues[i] = 1;
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            if (this.checkValues[i] == 0) {
                List deps = pack.revDependencies;
                for (int j = 0; deps != null && j < deps.size(); ++j) {
                    String name = (String)deps.get(j);
                    int pos = this.getPos(name);
                    this.checkValues[pos] = -2;
                }
            }
            if (this.checkValues[i] <= 0 || pack.excludeGroup == null) continue;
            for (int q = 0; q < this.packs.size(); ++q) {
                if (q == i) continue;
                Pack otherpack = (Pack)this.packs.get(q);
                if (!pack.excludeGroup.equals(otherpack.excludeGroup) || this.checkValues[q] != 1) continue;
                this.checkValues[q] = 0;
            }
        }
        for (Object pack1 : this.packs) {
            Pack pack2 = (Pack)pack1;
            if (!pack2.required) continue;
            this.propRequirement(pack2.name);
        }
        this.refreshPacksToInstall();
    }

    private void propRequirement(String name) {
        int pos = this.getPos(name);
        this.checkValues[pos] = -1;
        List deps = ((Pack)this.packs.get((int)pos)).dependencies;
        for (int i = 0; deps != null && i < deps.size(); ++i) {
            String s = (String)deps.get(i);
            this.propRequirement(s);
        }
    }

    private int getPos(String name) {
        return (Integer)this.namesPos.get(name);
    }

    public int getRowCount() {
        return this.packs.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.checkValues[rowIndex] < 0) {
            return false;
        }
        return columnIndex == 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Pack pack = (Pack)this.packs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.checkValues[rowIndex];
            }
            case 1: {
                Object name = null;
                if (this.langpack != null && pack.id != null && !pack.id.equals("")) {
                    name = this.langpack.get((Object)pack.id);
                }
                if (name == null || "".equals(name)) {
                    name = pack.name;
                }
                return name;
            }
            case 2: {
                return Pack.toByteUnitsString((long)pack.nbytes);
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Integer) {
            Pack pack = (Pack)this.packs.get(rowIndex);
            boolean packadded = false;
            if ((Integer)aValue == 1) {
                packadded = true;
                String packid = pack.id;
                if (packid != null) {
                    if (this.rules.canInstallPack(packid, this.variables) || this.rules.canInstallPackOptional(packid, this.variables)) {
                        this.checkValues[rowIndex] = pack.required ? -1 : 1;
                    }
                } else {
                    this.checkValues[rowIndex] = pack.required ? -1 : 1;
                }
            } else {
                packadded = false;
                this.checkValues[rowIndex] = 0;
            }
            this.updateExcludes(rowIndex);
            this.updateDeps();
            if (packadded) {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after adding pack " + pack.id);
                }
                this.packsToInstall.add(pack);
            } else {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after removing pack " + pack.id);
                }
                this.packsToInstall.remove(pack);
            }
            this.updateConditions();
            if (packadded) {
                this.packsToInstall.remove(pack);
            } else {
                this.packsToInstall.add(pack);
            }
            this.updateBytes();
            this.fireTableDataChanged();
            this.refreshPacksToInstall();
            this.panel.showSpaceRequired();
        }
    }

    private void refreshPacksToInstall() {
        String key;
        Pack pack;
        int i;
        this.packsToInstall.clear();
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            key = "";
            key = pack.id != null && pack.id.length() > 0 ? pack.id : pack.name;
            if (Math.abs(this.checkValues[i]) != 1 || this.installedpacks.containsKey(key)) continue;
            this.packsToInstall.add(pack);
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            key = "";
            key = pack.id != null && pack.id.length() > 0 ? pack.id : pack.name;
            if (!this.installedpacks.containsKey(key)) continue;
            this.checkValues[i] = -3;
        }
    }

    private void updateDeps() {
        int i;
        int[] statusArray = new int[this.packs.size()];
        for (i = 0; i < statusArray.length; ++i) {
            statusArray[i] = 0;
        }
        this.dfs(statusArray);
        for (i = 0; i < statusArray.length; ++i) {
            if (statusArray[i] == 0 && this.checkValues[i] < 0) {
                int n = i;
                this.checkValues[n] = this.checkValues[n] + 2;
            }
            if (statusArray[i] != 1 || this.checkValues[i] < 0) continue;
            this.checkValues[i] = -2;
        }
        for (Object pack1 : this.packs) {
            Pack pack = (Pack)pack1;
            if (!pack.required) continue;
            String packid = pack.id;
            if (packid != null) {
                if (!this.rules.canInstallPack(packid, this.variables) && this.rules.canInstallPackOptional(packid, this.variables)) continue;
                this.propRequirement(pack.name);
                continue;
            }
            this.propRequirement(pack.name);
        }
    }

    private void updateExcludes(int rowindex) {
        int value = this.checkValues[rowindex];
        Pack pack = (Pack)this.packs.get(rowindex);
        if (value > 0 && pack.excludeGroup != null) {
            for (int q = 0; q < this.packs.size(); ++q) {
                if (rowindex == q) continue;
                Pack otherpack = (Pack)this.packs.get(q);
                String name2 = pack.excludeGroup;
                String name1 = otherpack.excludeGroup;
                if (!name2.equals(name1) || this.checkValues[q] != 1) continue;
                this.checkValues[q] = 0;
            }
        }
    }

    private void updateBytes() {
        long bytes = 0L;
        for (int q = 0; q < this.packs.size(); ++q) {
            if (Math.abs(this.checkValues[q]) != 1) continue;
            Pack pack = (Pack)this.packs.get(q);
            bytes += pack.nbytes;
        }
        this.panel.setBytes(bytes);
    }

    private int dfs(int[] status) {
        for (int i = 0; i < this.packs.size(); ++i) {
            boolean wipe;
            for (Object pack1 : this.packs) {
                ((Pack)pack1).color = 0;
            }
            Pack pack = (Pack)this.packs.get(i);
            if (this.dfsVisit(pack, status, wipe = false) == 0) continue;
            return -1;
        }
        return 0;
    }

    private int dfsVisit(Pack u, int[] status, boolean wipe) {
        List deps;
        u.color = 1;
        int check = this.checkValues[this.getPos(u.name)];
        if (Math.abs(check) != 1) {
            wipe = true;
        }
        if ((deps = u.revDependencies) != null) {
            for (String name : deps) {
                int result;
                Pack v = (Pack)this.namesObj.get(name);
                if (wipe) {
                    status[this.getPos((String)v.name)] = 1;
                }
                if (v.color != 0 || (result = this.dfsVisit(v, status, wipe)) == 0) continue;
                return result;
            }
        }
        u.color = 2;
        return 0;
    }

    public Map getInstalledpacks() {
        return this.installedpacks;
    }

    public boolean isModifyinstallation() {
        return this.modifyinstallation;
    }
}

